/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class MixedNafR2LMultiplier
extends AbstractECMultiplier {
    protected int additionCoord;
    protected int doublingCoord;

    public MixedNafR2LMultiplier() {
        this(2, 4);
    }

    public MixedNafR2LMultiplier(int additionCoord, int doublingCoord) {
        this.additionCoord = additionCoord;
        this.doublingCoord = doublingCoord;
    }

    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        ECCurve eCCurve = p2.getCurve();
        ECCurve eCCurve2 = this.configureCurve(eCCurve, this.additionCoord);
        ECCurve eCCurve3 = this.configureCurve(eCCurve, this.doublingCoord);
        int[] nArray = WNafUtil.generateCompactNaf(k2);
        ECPoint eCPoint = eCCurve2.getInfinity();
        ECPoint eCPoint2 = eCCurve3.importPoint(p2);
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            int n4 = n3 >> 16;
            eCPoint2 = eCPoint2.timesPow2(n2 += n3 & 0xFFFF);
            ECPoint eCPoint3 = eCCurve2.importPoint(eCPoint2);
            if (n4 < 0) {
                eCPoint3 = eCPoint3.negate();
            }
            eCPoint = eCPoint.add(eCPoint3);
            n2 = 1;
        }
        return eCCurve.importPoint(eCPoint);
    }

    protected ECCurve configureCurve(ECCurve c2, int coord) {
        if (c2.getCoordinateSystem() == coord) {
            return c2;
        }
        if (!c2.supportsCoordinateSystem(coord)) {
            throw new IllegalArgumentException("Coordinate system " + coord + " not supported by this curve");
        }
        return c2.configure().setCoordinateSystem(coord).create();
    }
}

