/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class MontgomeryLadderMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        int n2;
        ECPoint[] eCPointArray = new ECPoint[]{p2.getCurve().getInfinity(), p2};
        int n3 = n2 = k2.bitLength();
        while (--n3 >= 0) {
            int n4 = k2.testBit(n3) ? 1 : 0;
            int n5 = 1 - n4;
            eCPointArray[n5] = eCPointArray[n5].add(eCPointArray[n4]);
            eCPointArray[n4] = eCPointArray[n4].twice();
        }
        return eCPointArray[0];
    }
}

