/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class NafL2RMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        int[] nArray = WNafUtil.generateCompactNaf(k2);
        ECPoint eCPoint = p2.normalize();
        ECPoint eCPoint2 = eCPoint.negate();
        ECPoint eCPoint3 = p2.getCurve().getInfinity();
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            int n4 = n3 >> 16;
            int n5 = n3 & 0xFFFF;
            eCPoint3 = eCPoint3.twicePlus(n4 < 0 ? eCPoint2 : eCPoint);
            eCPoint3 = eCPoint3.timesPow2(n5);
        }
        return eCPoint3;
    }
}

