/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WNafPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.math.ec.a;
import java.math.BigInteger;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p2, BigInteger k2) {
        ECPoint[] eCPointArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Math.max(2, Math.min(16, this.getWindowSize(k2.bitLength())));
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(p2, n6, true);
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray3 = wNafPreCompInfo.getPreCompNeg();
        int[] nArray = WNafUtil.generateCompactWindowNaf(n6, k2);
        ECPoint eCPoint = p2.getCurve().getInfinity();
        int n7 = nArray.length;
        if (n7 > 1) {
            n5 = nArray[--n7];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            ECPoint[] eCPointArray4 = eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            if (n2 << 2 < 1 << n6) {
                byte by = a.a[n2];
                int n8 = n6 - by;
                int n9 = n2 ^ 1 << by - 1;
                int n10 = (1 << n6 - 1) - 1;
                int n11 = (n9 << n8) + 1;
                eCPoint = eCPointArray[n10 >>> 1].add(eCPointArray[n11 >>> 1]);
                n3 -= n8;
            } else {
                eCPoint = eCPointArray[n2 >>> 1];
            }
            eCPoint = eCPoint.timesPow2(n3);
        }
        while (n7 > 0) {
            n5 = nArray[--n7];
            n4 = n5 >> 16;
            n3 = n5 & 0xFFFF;
            n2 = Math.abs(n4);
            eCPointArray = n4 < 0 ? eCPointArray3 : eCPointArray2;
            ECPoint eCPoint2 = eCPointArray[n2 >>> 1];
            eCPoint = eCPoint.twicePlus(eCPoint2);
            eCPoint = eCPoint.timesPow2(n3);
        }
        return eCPoint;
    }

    protected int getWindowSize(int bits) {
        return WNafUtil.getWindowSize(bits);
    }
}

