/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.gm;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SM2P256V1Field {
    static final int[] a = new int[]{-1, -1, 0, -1, -1, -1, -1, -2};
    static final int[] b = new int[]{1, 0, -2, 1, 1, -2, 0, 2, -2, -3, 3, -2, -1, -1, 0, -2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat256.add(x2, y2, z2);
        if (n2 != 0 || z2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z2, a)) {
            SM2P256V1Field.a(z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(16, xx, yy, zz);
        if (n2 != 0 || zz[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, zz, b)) {
            Nat.subFrom(16, b, zz);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(8, x2, z2);
        if (n2 != 0 || z2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z2, a)) {
            SM2P256V1Field.a(z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat256.fromBigInteger(x2);
        if (nArray[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(8, x2, 0, z2);
        } else {
            int n2 = Nat256.add(x2, a, z2);
            Nat.shiftDownBit(8, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x2, y2, nArray);
        SM2P256V1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat256.mulAddTo(x2, y2, zz);
        if (n2 != 0 || zz[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, zz, b)) {
            Nat.subFrom(16, b, zz);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat256.isZero(x2)) {
            Nat256.zero(z2);
        } else {
            Nat256.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = (long)xx[8] & 0xFFFFFFFFL;
        long l3 = (long)xx[9] & 0xFFFFFFFFL;
        long l4 = (long)xx[10] & 0xFFFFFFFFL;
        long l5 = (long)xx[11] & 0xFFFFFFFFL;
        long l6 = (long)xx[12] & 0xFFFFFFFFL;
        long l7 = (long)xx[13] & 0xFFFFFFFFL;
        long l8 = (long)xx[14] & 0xFFFFFFFFL;
        long l9 = (long)xx[15] & 0xFFFFFFFFL;
        long l10 = l2 + l3;
        long l11 = l4 + l5;
        long l12 = l6 + l9;
        long l13 = l7 + l8;
        long l14 = l13 + (l9 << 1);
        long l15 = l10 + l13;
        long l16 = l11 + l12 + l15;
        long l17 = 0L;
        z2[0] = (int)(l17 += ((long)xx[0] & 0xFFFFFFFFL) + l16 + l7 + l8 + l9);
        l17 >>= 32;
        z2[1] = (int)(l17 += ((long)xx[1] & 0xFFFFFFFFL) + l16 - l2 + l8 + l9);
        l17 >>= 32;
        z2[2] = (int)(l17 += ((long)xx[2] & 0xFFFFFFFFL) - l15);
        l17 >>= 32;
        z2[3] = (int)(l17 += ((long)xx[3] & 0xFFFFFFFFL) + l16 - l3 - l4 + l7);
        l17 >>= 32;
        z2[4] = (int)(l17 += ((long)xx[4] & 0xFFFFFFFFL) + l16 - l11 - l2 + l8);
        l17 >>= 32;
        z2[5] = (int)(l17 += ((long)xx[5] & 0xFFFFFFFFL) + l14 + l4);
        l17 >>= 32;
        z2[6] = (int)(l17 += ((long)xx[6] & 0xFFFFFFFFL) + l5 + l8 + l9);
        l17 >>= 32;
        z2[7] = (int)(l17 += ((long)xx[7] & 0xFFFFFFFFL) + l16 + l14 + l6);
        SM2P256V1Field.reduce32((int)(l17 >>= 32), z2);
    }

    public static void reduce32(int x2, int[] z2) {
        long l2 = 0L;
        if (x2 != 0) {
            long l3 = (long)x2 & 0xFFFFFFFFL;
            z2[0] = (int)(l2 += ((long)z2[0] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z2[1] = (int)(l2 += (long)z2[1] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z2[2] = (int)(l2 += ((long)z2[2] & 0xFFFFFFFFL) - l3);
            l2 >>= 32;
            z2[3] = (int)(l2 += ((long)z2[3] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z2[4] = (int)(l2 += (long)z2[4] & 0xFFFFFFFFL);
                l2 >>= 32;
                z2[5] = (int)(l2 += (long)z2[5] & 0xFFFFFFFFL);
                l2 >>= 32;
                z2[6] = (int)(l2 += (long)z2[6] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z2[7] = (int)(l2 += ((long)z2[7] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
        }
        if (l2 != 0L || z2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z2, a)) {
            SM2P256V1Field.a(z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        SM2P256V1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x2, nArray);
        SM2P256V1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat256.square(z2, nArray);
            SM2P256V1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat256.sub(x2, y2, z2);
        if (n2 != 0) {
            SM2P256V1Field.b(z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0) {
            Nat.addTo(16, b, zz);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(8, x2, 0, z2);
        if (n2 != 0 || z2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z2, a)) {
            SM2P256V1Field.a(z2);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) - 1L);
        l2 >>= 32;
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[4] = (int)(l2 += (long)nArray[4] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[5] = (int)(l2 += (long)nArray[5] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[6] = (int)(l2 += (long)nArray[6] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) + 1L);
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) + 1L);
        l2 >>= 32;
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[4] = (int)(l2 += (long)nArray[4] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[5] = (int)(l2 += (long)nArray[5] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[6] = (int)(l2 += (long)nArray[6] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) - 1L);
    }
}

