/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP160R1FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP160R1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat160;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"));
    protected SecP160R1Point infinity = new SecP160R1Point(this, null, null);

    public SecP160R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000001F4C8F927AED3CA752257"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x2) {
        return new SecP160R1FieldElement(x2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
        return new SecP160R1Point((ECCurve)this, x2, y2, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
        return new SecP160R1Point(this, x2, y2, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 5;
        final int[] nArray = new int[len * 5 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat160.copy(((SecP160R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 5; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 5 + i3] & n3;
                    }
                    n2 += 10;
                }
                return SecP160R1Curve.this.createRawPoint(new SecP160R1FieldElement(nArray3), new SecP160R1FieldElement(nArray2), false);
            }
        };
    }
}

