/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat160;
import java.math.BigInteger;

public class SecP160R2Field {
    static final int[] a = new int[]{-21389, -2, -1, -1, -1};
    static final int[] b = new int[]{457489321, 42778, 1, 0, 0, -42778, -3, -1, -1, -1};
    private static final int[] c = new int[]{-457489321, -42779, -2, -1, -1, 42777, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat160.add(x2, y2, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.add33To(5, 21389, z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(10, xx, yy, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(5, x2, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.add33To(5, 21389, z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat160.fromBigInteger(x2);
        if (nArray[4] == -1 && Nat160.gte(nArray, a)) {
            Nat160.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(5, x2, 0, z2);
        } else {
            int n2 = Nat160.add(x2, a, z2);
            Nat.shiftDownBit(5, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.mul(x2, y2, nArray);
        SecP160R2Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat160.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[9] == -1 && Nat.gte(10, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(10, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat160.isZero(x2)) {
            Nat160.zero(z2);
        } else {
            Nat160.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = Nat160.mul33Add(21389, xx, 5, xx, 0, z2, 0);
        int n2 = Nat160.mul33DWordAdd(21389, l2, z2, 0);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.add33To(5, 21389, z2);
        }
    }

    public static void reduce32(int x2, int[] z2) {
        if (x2 != 0 && Nat160.mul33WordAdd(21389, x2, z2, 0) != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.add33To(5, 21389, z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x2, nArray);
        SecP160R2Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat160.createExt();
        Nat160.square(x2, nArray);
        SecP160R2Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat160.square(z2, nArray);
            SecP160R2Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat160.sub(x2, y2, z2);
        if (n2 != 0) {
            Nat.sub33From(5, 21389, z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(10, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(10, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(5, x2, 0, z2);
        if (n2 != 0 || z2[4] == -1 && Nat160.gte(z2, a)) {
            Nat.add33To(5, 21389, z2);
        }
    }
}

