/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecP192K1Field {
    static final int[] a = new int[]{-4553, -2, -1, -1, -1, -1};
    static final int[] b = new int[]{20729809, 9106, 1, 0, 0, 0, -9106, -3, -1, -1, -1, -1};
    private static final int[] c = new int[]{-20729809, -9107, -2, -1, -1, -1, 9105, 2};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat192.add(x2, y2, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            Nat.add33To(6, 4553, z2);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(12, xx, yy, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(6, x2, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            Nat.add33To(6, 4553, z2);
        }
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat192.fromBigInteger(x2);
        if (nArray[5] == -1 && Nat192.gte(nArray, a)) {
            Nat192.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        if ((x2[0] & 1) == 0) {
            Nat.shiftDownBit(6, x2, 0, z2);
        } else {
            int n2 = Nat192.add(x2, a, z2);
            Nat.shiftDownBit(6, z2, n2);
        }
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.mul(x2, y2, nArray);
        SecP192K1Field.reduce(nArray, z2);
    }

    public static void multiplyAddToExt(int[] x2, int[] y2, int[] zz) {
        int n2 = Nat192.mulAddTo(x2, y2, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat192.isZero(x2)) {
            Nat192.zero(z2);
        } else {
            Nat192.sub(a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        long l2 = Nat192.mul33Add(4553, xx, 6, xx, 0, z2, 0);
        int n2 = Nat192.mul33DWordAdd(4553, l2, z2, 0);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            Nat.add33To(6, 4553, z2);
        }
    }

    public static void reduce32(int x2, int[] z2) {
        if (x2 != 0 && Nat192.mul33WordAdd(4553, x2, z2, 0) != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            Nat.add33To(6, 4553, z2);
        }
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x2, nArray);
        SecP192K1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x2, nArray);
        SecP192K1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            Nat192.square(z2, nArray);
            SecP192K1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat192.sub(x2, y2, z2);
        if (n2 != 0) {
            Nat.sub33From(6, 4553, z2);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(12, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(12, zz, c.length);
        }
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = Nat.shiftUpBit(6, x2, 0, z2);
        if (n2 != 0 || z2[5] == -1 && Nat192.gte(z2, a)) {
            Nat.add33To(6, 4553, z2);
        }
    }
}

