/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP521R1FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP521R1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP521R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"));
    protected SecP521R1Point infinity = new SecP521R1Point(this, null, null);

    public SecP521R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00")));
        this.order = new BigInteger(1, Hex.decode("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP521R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x2) {
        return new SecP521R1FieldElement(x2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
        return new SecP521R1Point((ECCurve)this, x2, y2, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
        return new SecP521R1Point(this, x2, y2, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 17;
        final int[] nArray = new int[len * 17 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 17);
            n3 += 17;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat.create(17);
                int[] nArray2 = Nat.create(17);
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 17; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 17 + i3] & n3;
                    }
                    n2 += 34;
                }
                return SecP521R1Curve.this.createRawPoint(new SecP521R1FieldElement(nArray3), new SecP521R1FieldElement(nArray2), false);
            }
        };
    }
}

