/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat512;
import java.math.BigInteger;

public class SecP521R1Field {
    static final int[] a = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};

    public static void add(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat.add(16, x2, y2, z2) + x2[16] + y2[16];
        if (n2 > 511 || n2 == 511 && Nat.eq(16, z2, a)) {
            n2 += Nat.inc(16, z2);
            n2 &= 0x1FF;
        }
        z2[16] = n2;
    }

    public static void addOne(int[] x2, int[] z2) {
        int n2 = Nat.inc(16, x2, z2) + x2[16];
        if (n2 > 511 || n2 == 511 && Nat.eq(16, z2, a)) {
            n2 += Nat.inc(16, z2);
            n2 &= 0x1FF;
        }
        z2[16] = n2;
    }

    public static int[] fromBigInteger(BigInteger x2) {
        int[] nArray = Nat.fromBigInteger(521, x2);
        if (Nat.eq(17, nArray, a)) {
            Nat.zero(17, nArray);
        }
        return nArray;
    }

    public static void half(int[] x2, int[] z2) {
        int n2 = x2[16];
        int n3 = Nat.shiftDownBit(16, x2, n2, z2);
        z2[16] = n2 >>> 1 | n3 >>> 23;
    }

    public static void multiply(int[] x2, int[] y2, int[] z2) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implMultiply(x2, y2, nArray);
        SecP521R1Field.reduce(nArray, z2);
    }

    public static void negate(int[] x2, int[] z2) {
        if (Nat.isZero(17, x2)) {
            Nat.zero(17, z2);
        } else {
            Nat.sub(17, a, x2, z2);
        }
    }

    public static void reduce(int[] xx, int[] z2) {
        int n2 = xx[32];
        int n3 = Nat.shiftDownBits(16, xx, 16, 9, n2, z2, 0) >>> 23;
        n3 += n2 >>> 9;
        if ((n3 += Nat.addTo(16, xx, z2)) > 511 || n3 == 511 && Nat.eq(16, z2, a)) {
            n3 += Nat.inc(16, z2);
            n3 &= 0x1FF;
        }
        z2[16] = n3;
    }

    public static void reduce23(int[] z2) {
        int n2 = z2[16];
        int n3 = Nat.addWordTo(16, n2 >>> 9, z2) + (n2 & 0x1FF);
        if (n3 > 511 || n3 == 511 && Nat.eq(16, z2, a)) {
            n3 += Nat.inc(16, z2);
            n3 &= 0x1FF;
        }
        z2[16] = n3;
    }

    public static void square(int[] x2, int[] z2) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implSquare(x2, nArray);
        SecP521R1Field.reduce(nArray, z2);
    }

    public static void squareN(int[] x2, int n2, int[] z2) {
        int[] nArray = Nat.create(33);
        SecP521R1Field.implSquare(x2, nArray);
        SecP521R1Field.reduce(nArray, z2);
        while (--n2 > 0) {
            SecP521R1Field.implSquare(z2, nArray);
            SecP521R1Field.reduce(nArray, z2);
        }
    }

    public static void subtract(int[] x2, int[] y2, int[] z2) {
        int n2 = Nat.sub(16, x2, y2, z2) + x2[16] - y2[16];
        if (n2 < 0) {
            n2 += Nat.dec(16, z2);
            n2 &= 0x1FF;
        }
        z2[16] = n2;
    }

    public static void twice(int[] x2, int[] z2) {
        int n2 = x2[16];
        int n3 = Nat.shiftUpBit(16, x2, n2 << 23, z2) | n2 << 1;
        z2[16] = n3 & 0x1FF;
    }

    protected static void implMultiply(int[] x2, int[] y2, int[] zz) {
        Nat512.mul(x2, y2, zz);
        int n2 = x2[16];
        int n3 = y2[16];
        zz[32] = Nat.mul31BothAdd(16, n2, y2, n3, x2, zz, 16) + n2 * n3;
    }

    protected static void implSquare(int[] x2, int[] zz) {
        Nat512.square(x2, zz);
        int n2 = x2[16];
        zz[32] = Nat.mulWordAddTo(16, n2 << 1, x2, 0, zz, 16) + n2 * n2;
    }
}

