/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP521R1Curve;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP521R1Field;
import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecP521R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = SecP521R1Curve.q;
    protected int[] x;

    public SecP521R1FieldElement(BigInteger x2) {
        if (x2 == null || x2.signum() < 0 || x2.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP521R1FieldElement");
        }
        this.x = SecP521R1Field.fromBigInteger(x2);
    }

    public SecP521R1FieldElement() {
        this.x = Nat.create(17);
    }

    protected SecP521R1FieldElement(int[] x2) {
        this.x = x2;
    }

    @Override
    public boolean isZero() {
        return Nat.isZero(17, this.x);
    }

    @Override
    public boolean isOne() {
        return Nat.isOne(17, this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat.toBigInteger(17, this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP521R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.add(this.x, ((SecP521R1FieldElement)b2).x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.addOne(this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.subtract(this.x, ((SecP521R1FieldElement)b2).x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.multiply(this.x, ((SecP521R1FieldElement)b2).x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        int[] nArray = Nat.create(17);
        Mod.invert(SecP521R1Field.a, ((SecP521R1FieldElement)b2).x, nArray);
        SecP521R1Field.multiply(nArray, this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.negate(this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.square(this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat.create(17);
        Mod.invert(SecP521R1Field.a, this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat.isZero(17, nArray) || Nat.isOne(17, nArray)) {
            return this;
        }
        int[] nArray2 = Nat.create(17);
        int[] nArray3 = Nat.create(17);
        SecP521R1Field.squareN(nArray, 519, nArray2);
        SecP521R1Field.square(nArray2, nArray3);
        return Nat.eq(17, nArray, nArray3) ? new SecP521R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecP521R1FieldElement)) {
            return false;
        }
        SecP521R1FieldElement secP521R1FieldElement = (SecP521R1FieldElement)other;
        return Nat.eq(17, this.x, secP521R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 17);
    }
}

