/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT131Field;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT131FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT131FieldElement(BigInteger x2) {
        if (x2 == null || x2.signum() < 0 || x2.bitLength() > 131) {
            throw new IllegalArgumentException("x value invalid for SecT131FieldElement");
        }
        this.x = SecT131Field.fromBigInteger(x2);
    }

    public SecT131FieldElement() {
        this.x = Nat192.create64();
    }

    protected SecT131FieldElement(long[] x2) {
        this.x = x2;
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT131Field";
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        long[] lArray = Nat192.create64();
        SecT131Field.add(this.x, ((SecT131FieldElement)b2).x, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat192.create64();
        SecT131Field.addOne(this.x, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        return this.add(b2);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        long[] lArray = Nat192.create64();
        SecT131Field.multiply(this.x, ((SecT131FieldElement)b2).x, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        return this.multiplyPlusProduct(b2, x2, y2);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT131FieldElement)b2).x;
        long[] lArray3 = ((SecT131FieldElement)x2).x;
        long[] lArray4 = ((SecT131FieldElement)y2).x;
        long[] lArray5 = Nat.create64(5);
        SecT131Field.multiplyAddToExt(lArray, lArray2, lArray5);
        SecT131Field.multiplyAddToExt(lArray3, lArray4, lArray5);
        long[] lArray6 = Nat192.create64();
        SecT131Field.reduce(lArray5, lArray6);
        return new SecT131FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        return this.multiply(b2.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat192.create64();
        SecT131Field.square(this.x, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement x2, ECFieldElement y2) {
        return this.squarePlusProduct(x2, y2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT131FieldElement)x2).x;
        long[] lArray3 = ((SecT131FieldElement)y2).x;
        long[] lArray4 = Nat.create64(5);
        SecT131Field.squareAddToExt(lArray, lArray4);
        SecT131Field.multiplyAddToExt(lArray2, lArray3, lArray4);
        long[] lArray5 = Nat192.create64();
        SecT131Field.reduce(lArray4, lArray5);
        return new SecT131FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int pow) {
        if (pow < 1) {
            return this;
        }
        long[] lArray = Nat192.create64();
        SecT131Field.squareN(this.x, pow, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public int trace() {
        return SecT131Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat192.create64();
        SecT131Field.invert(this.x, lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat192.create64();
        SecT131Field.sqrt(this.x, lArray);
        return new SecT131FieldElement(lArray);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 131;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecT131FieldElement)) {
            return false;
        }
        SecT131FieldElement secT131FieldElement = (SecT131FieldElement)other;
        return Nat192.eq64(this.x, secT131FieldElement.x);
    }

    public int hashCode() {
        return 0x202F8 ^ Arrays.hashCode(this.x, 0, 3);
    }
}

