/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT233Field;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT233FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT233FieldElement(BigInteger x2) {
        if (x2 == null || x2.signum() < 0 || x2.bitLength() > 233) {
            throw new IllegalArgumentException("x value invalid for SecT233FieldElement");
        }
        this.x = SecT233Field.fromBigInteger(x2);
    }

    public SecT233FieldElement() {
        this.x = Nat256.create64();
    }

    protected SecT233FieldElement(long[] x2) {
        this.x = x2;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT233Field";
    }

    @Override
    public int getFieldSize() {
        return 233;
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        long[] lArray = Nat256.create64();
        SecT233Field.add(this.x, ((SecT233FieldElement)b2).x, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat256.create64();
        SecT233Field.addOne(this.x, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        return this.add(b2);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        long[] lArray = Nat256.create64();
        SecT233Field.multiply(this.x, ((SecT233FieldElement)b2).x, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        return this.multiplyPlusProduct(b2, x2, y2);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT233FieldElement)b2).x;
        long[] lArray3 = ((SecT233FieldElement)x2).x;
        long[] lArray4 = ((SecT233FieldElement)y2).x;
        long[] lArray5 = Nat256.createExt64();
        SecT233Field.multiplyAddToExt(lArray, lArray2, lArray5);
        SecT233Field.multiplyAddToExt(lArray3, lArray4, lArray5);
        long[] lArray6 = Nat256.create64();
        SecT233Field.reduce(lArray5, lArray6);
        return new SecT233FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        return this.multiply(b2.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat256.create64();
        SecT233Field.square(this.x, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement x2, ECFieldElement y2) {
        return this.squarePlusProduct(x2, y2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement x2, ECFieldElement y2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT233FieldElement)x2).x;
        long[] lArray3 = ((SecT233FieldElement)y2).x;
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.squareAddToExt(lArray, lArray4);
        SecT233Field.multiplyAddToExt(lArray2, lArray3, lArray4);
        long[] lArray5 = Nat256.create64();
        SecT233Field.reduce(lArray4, lArray5);
        return new SecT233FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int pow) {
        if (pow < 1) {
            return this;
        }
        long[] lArray = Nat256.create64();
        SecT233Field.squareN(this.x, pow, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public int trace() {
        return SecT233Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat256.create64();
        SecT233Field.invert(this.x, lArray);
        return new SecT233FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat256.create64();
        SecT233Field.sqrt(this.x, lArray);
        return new SecT233FieldElement(lArray);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 233;
    }

    public int getK1() {
        return 74;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecT233FieldElement)) {
            return false;
        }
        SecT233FieldElement secT233FieldElement = (SecT233FieldElement)other;
        return Nat256.eq64(this.x, secT233FieldElement.x);
    }

    public int hashCode() {
        return 0x238DDA ^ Arrays.hashCode(this.x, 0, 4);
    }
}

