/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.WTauNafMultiplier;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT233FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT233K1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT233K1Curve
extends ECCurve.AbstractF2m {
    protected SecT233K1Point infinity = new SecT233K1Point(this, null, null);

    public SecT233K1Curve() {
        super(233, 74, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDF"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT233K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 233;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x2) {
        return new SecT233FieldElement(x2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
        return new SecT233K1Point((ECCurve)this, x2, y2, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
        return new SecT233K1Point(this, x2, y2, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 233;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 74;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 4;
        final long[] lArray = new long[len * 4 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat256.copy64(((SecT233FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 4);
            n3 += 4;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] lArray3 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    long l2 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        int n3 = i3;
                        lArray3[n3] = lArray3[n3] ^ lArray[n2 + i3] & l2;
                        int n4 = i3;
                        lArray2[n4] = lArray2[n4] ^ lArray[n2 + 4 + i3] & l2;
                    }
                    n2 += 8;
                }
                return SecT233K1Curve.this.createRawPoint(new SecT233FieldElement(lArray3), new SecT233FieldElement(lArray2), false);
            }
        };
    }
}

