/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat576;
import java.math.BigInteger;

public class SecT571Field {
    private static final long[] a = new long[]{3161836309350906777L, -7642453882179322845L, -3821226941089661423L, 7312758566309945096L, -556661012383879292L, 8945041530681231562L, -4750851271514160027L, 6847946401097695794L, 541669439031730457L};

    public static void add(long[] x2, long[] y2, long[] z2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            z2[i2] = x2[i2] ^ y2[i2];
        }
    }

    private static void a(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4) {
        for (int i2 = 0; i2 < 9; ++i2) {
            lArray3[n4 + i2] = lArray[n2 + i2] ^ lArray2[n3 + i2];
        }
    }

    public static void addBothTo(long[] x2, long[] y2, long[] z2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n2 = i2;
            z2[n2] = z2[n2] ^ (x2[i2] ^ y2[i2]);
        }
    }

    private static void b(long[] lArray, int n2, long[] lArray2, int n3, long[] lArray3, int n4) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n5 = n4 + i2;
            lArray3[n5] = lArray3[n5] ^ (lArray[n2 + i2] ^ lArray2[n3 + i2]);
        }
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        for (int i2 = 0; i2 < 18; ++i2) {
            zz[i2] = xx[i2] ^ yy[i2];
        }
    }

    public static void addOne(long[] x2, long[] z2) {
        z2[0] = x2[0] ^ 1L;
        for (int i2 = 1; i2 < 9; ++i2) {
            z2[i2] = x2[i2];
        }
    }

    public static long[] fromBigInteger(BigInteger x2) {
        long[] lArray = Nat576.fromBigInteger64(x2);
        SecT571Field.reduce5(lArray, 0);
        return lArray;
    }

    public static void invert(long[] x2, long[] z2) {
        if (Nat576.isZero64(x2)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat576.create64();
        long[] lArray2 = Nat576.create64();
        long[] lArray3 = Nat576.create64();
        SecT571Field.square(x2, lArray3);
        SecT571Field.square(lArray3, lArray);
        SecT571Field.square(lArray, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 2, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.multiply(lArray, lArray3, lArray);
        SecT571Field.squareN(lArray, 5, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 5, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 15, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray3);
        SecT571Field.squareN(lArray3, 30, lArray);
        SecT571Field.squareN(lArray, 30, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 60, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 60, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray, 180, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.squareN(lArray2, 180, lArray2);
        SecT571Field.multiply(lArray, lArray2, lArray);
        SecT571Field.multiply(lArray, lArray3, z2);
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiply(x2, y2, lArray);
        SecT571Field.reduce(lArray, z2);
    }

    public static void multiplyAddToExt(long[] x2, long[] y2, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiply(x2, y2, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static void multiplyPrecomp(long[] x2, long[] precomp, long[] z2) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(x2, precomp, lArray);
        SecT571Field.reduce(lArray, z2);
    }

    public static void multiplyPrecompAddToExt(long[] x2, long[] precomp, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implMultiplyPrecomp(x2, precomp, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static long[] precompMultiplicand(long[] x2) {
        int n2 = 144;
        long[] lArray = new long[n2 << 1];
        System.arraycopy(x2, 0, lArray, 9, 9);
        int n3 = 0;
        for (int i2 = 7; i2 > 0; --i2) {
            Nat.shiftUpBit64(9, lArray, (n3 += 18) >>> 1, 0L, lArray, n3);
            SecT571Field.reduce5(lArray, n3);
            SecT571Field.a(lArray, 9, lArray, n3, lArray, n3 + 9);
        }
        Nat.shiftUpBits64(n2, lArray, 0, 4, 0L, lArray, n2);
        return lArray;
    }

    public static void reduce(long[] xx, long[] z2) {
        long l2 = xx[9];
        long l3 = xx[17];
        long l4 = l2;
        l2 = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
        l4 = xx[8] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        for (int i2 = 16; i2 >= 10; --i2) {
            l3 = xx[i2];
            z2[i2 - 8] = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
            l4 = xx[i2 - 9] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        }
        l3 = l2;
        z2[1] = l4 ^ l3 >>> 59 ^ l3 >>> 57 ^ l3 >>> 54 ^ l3 >>> 49;
        l4 = xx[0] ^ l3 << 5 ^ l3 << 7 ^ l3 << 10 ^ l3 << 15;
        long l5 = z2[8];
        long l6 = l5 >>> 59;
        z2[0] = l4 ^ l6 ^ l6 << 2 ^ l6 << 5 ^ l6 << 10;
        z2[8] = l5 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void reduce5(long[] z2, int zOff) {
        long l2 = z2[zOff + 8];
        long l3 = l2 >>> 59;
        int n2 = zOff;
        z2[n2] = z2[n2] ^ (l3 ^ l3 << 2 ^ l3 << 5 ^ l3 << 10);
        z2[zOff + 8] = l2 & 0x7FFFFFFFFFFFFFFL;
    }

    public static void sqrt(long[] x2, long[] z2) {
        long[] lArray = Nat576.create64();
        long[] lArray2 = Nat576.create64();
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            long l2 = Interleave.unshuffle(x2[n2++]);
            long l3 = Interleave.unshuffle(x2[n2++]);
            lArray[i2] = l2 & 0xFFFFFFFFL | l3 << 32;
            lArray2[i2] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        }
        long l4 = Interleave.unshuffle(x2[n2]);
        lArray[4] = l4 & 0xFFFFFFFFL;
        lArray2[4] = l4 >>> 32;
        SecT571Field.multiply(lArray2, a, z2);
        SecT571Field.add(z2, lArray, z2);
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x2, lArray);
        SecT571Field.reduce(lArray, z2);
    }

    public static void squareAddToExt(long[] x2, long[] zz) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x2, lArray);
        SecT571Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x2, int n2, long[] z2) {
        long[] lArray = Nat576.createExt64();
        SecT571Field.implSquare(x2, lArray);
        SecT571Field.reduce(lArray, z2);
        while (--n2 > 0) {
            SecT571Field.implSquare(z2, lArray);
            SecT571Field.reduce(lArray, z2);
        }
    }

    public static int trace(long[] x2) {
        return (int)(x2[0] ^ x2[8] >>> 49 ^ x2[8] >>> 57) & 1;
    }

    protected static void implMultiply(long[] x2, long[] y2, long[] zz) {
        long[] lArray = SecT571Field.precompMultiplicand(y2);
        SecT571Field.implMultiplyPrecomp(x2, lArray, zz);
    }

    protected static void implMultiplyPrecomp(long[] x2, long[] precomp, long[] zz) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 15;
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 1; n5 < 9; n5 += 2) {
                n4 = (int)(x2[n5] >>> n6);
                n3 = n4 & n7;
                n2 = n4 >>> 4 & n7;
                SecT571Field.b(precomp, 9 * n3, precomp, 9 * (n2 + 16), zz, n5 - 1);
            }
            Nat.shiftUpBits64(16, zz, 0, 8, 0L);
        }
        for (n6 = 56; n6 >= 0; n6 -= 8) {
            for (n5 = 0; n5 < 9; n5 += 2) {
                n4 = (int)(x2[n5] >>> n6);
                n3 = n4 & n7;
                n2 = n4 >>> 4 & n7;
                SecT571Field.b(precomp, 9 * n3, precomp, 9 * (n2 + 16), zz, n5);
            }
            if (n6 <= 0) continue;
            Nat.shiftUpBits64(18, zz, 0, 8, 0L);
        }
    }

    protected static void implMulwAcc(long[] xs, long y2, long[] z2, int zOff) {
        long[] lArray = new long[32];
        lArray[1] = y2;
        for (int i2 = 2; i2 < 32; i2 += 2) {
            lArray[i2] = lArray[i2 >>> 1] << 1;
            lArray[i2 + 1] = lArray[i2] ^ y2;
        }
        long l2 = 0L;
        for (int i3 = 0; i3 < 9; ++i3) {
            long l3 = xs[i3];
            int n2 = (int)l3;
            l2 ^= lArray[n2 & 0x1F];
            long l4 = 0L;
            int n3 = 60;
            do {
                n2 = (int)(l3 >>> n3);
                long l5 = lArray[n2 & 0x1F];
                l2 ^= l5 << n3;
                l4 ^= l5 >>> -n3;
            } while ((n3 -= 5) > 0);
            for (int i4 = 0; i4 < 4; ++i4) {
                l3 = (l3 & 0xEF7BDEF7BDEF7BDEL) >>> 1;
                l4 ^= l3 & y2 << i4 >> 63;
            }
            int n4 = zOff + i3;
            z2[n4] = z2[n4] ^ l2;
            l2 = l4;
        }
        int n5 = zOff + 9;
        z2[n5] = z2[n5] ^ l2;
    }

    protected static void implSquare(long[] x2, long[] zz) {
        for (int i2 = 0; i2 < 9; ++i2) {
            Interleave.expand64To128(x2[i2], zz, i2 << 1);
        }
    }
}

