/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.endo;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPointMap;
import com.enterprisedt.bouncycastle.math.ec.ScaleXPointMap;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVTypeBParameters;
import java.math.BigInteger;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final ECCurve curve;
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve curve, GLVTypeBParameters parameters) {
        this.curve = curve;
        this.parameters = parameters;
        this.pointMap = new ScaleXPointMap(curve.fromBigInteger(parameters.getBeta()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger k2) {
        int n2 = this.parameters.getBits();
        BigInteger bigInteger = this.calculateB(k2, this.parameters.getG1(), n2);
        BigInteger bigInteger2 = this.calculateB(k2, this.parameters.getG2(), n2);
        GLVTypeBParameters gLVTypeBParameters = this.parameters;
        BigInteger bigInteger3 = k2.subtract(bigInteger.multiply(gLVTypeBParameters.getV1A()).add(bigInteger2.multiply(gLVTypeBParameters.getV2A())));
        BigInteger bigInteger4 = bigInteger.multiply(gLVTypeBParameters.getV1B()).add(bigInteger2.multiply(gLVTypeBParameters.getV2B())).negate();
        return new BigInteger[]{bigInteger3, bigInteger4};
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }

    protected BigInteger calculateB(BigInteger k2, BigInteger g2, int t2) {
        boolean bl = g2.signum() < 0;
        BigInteger bigInteger = k2.multiply(g2.abs());
        boolean bl2 = bigInteger.testBit(t2 - 1);
        bigInteger = bigInteger.shiftRight(t2);
        if (bl2) {
            bigInteger = bigInteger.add(ECConstants.ONE);
        }
        return bl ? bigInteger.negate() : bigInteger;
    }
}

