/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GMSSPublicKey
extends ASN1Object {
    private ASN1Integer a;
    private byte[] b;

    private GMSSPublicKey(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("size of seq = " + seq.size());
        }
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.b = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
    }

    public GMSSPublicKey(byte[] publicKeyBytes) {
        this.a = new ASN1Integer(0L);
        this.b = publicKeyBytes;
    }

    public static GMSSPublicKey getInstance(Object o2) {
        if (o2 instanceof GMSSPublicKey) {
            return (GMSSPublicKey)o2;
        }
        if (o2 != null) {
            return new GMSSPublicKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public byte[] getPublicKey() {
        return Arrays.clone(this.b);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DEROctetString(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

