/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.mceliece;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageEncryptor;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private Digest b;
    private SecureRandom c;
    private int d;
    private int e;
    private int f;
    McElieceCCA2KeyParameters a;
    private boolean g;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.g = forEncryption;
        if (forEncryption) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.c = parametersWithRandom.getRandom();
                this.a = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                this.a((McElieceCCA2PublicKeyParameters)this.a);
            } else {
                this.c = CryptoServicesRegistrar.getSecureRandom();
                this.a = (McElieceCCA2PublicKeyParameters)param;
                this.a((McElieceCCA2PublicKeyParameters)this.a);
            }
        } else {
            this.a = (McElieceCCA2PrivateKeyParameters)param;
            this.a((McElieceCCA2PrivateKeyParameters)this.a);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters key) throws IllegalArgumentException {
        if (key instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)key).getN();
        }
        if (key instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void a(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.c = this.c != null ? this.c : CryptoServicesRegistrar.getSecureRandom();
        this.b = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PublicKeyParameters.getDigest());
        this.d = mcElieceCCA2PublicKeyParameters.getN();
        this.e = mcElieceCCA2PublicKeyParameters.getK();
        this.f = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void a(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.b = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.d = mcElieceCCA2PrivateKeyParameters.getN();
        this.f = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] input) {
        if (!this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = new GF2Vector(this.e, this.c);
        byte[] byArray = gF2Vector.getEncoded();
        byte[] byArray2 = ByteUtils.concatenate(byArray, input);
        this.b.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray3, 0);
        GF2Vector gF2Vector2 = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray3);
        byte[] byArray4 = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PublicKeyParameters)this.a, gF2Vector, gF2Vector2).getEncoded();
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray);
        byte[] byArray5 = new byte[input.length];
        digestRandomGenerator.nextBytes(byArray5);
        for (int i2 = 0; i2 < input.length; ++i2) {
            int n2 = i2;
            byArray5[n2] = (byte)(byArray5[n2] ^ input[i2]);
        }
        return ByteUtils.concatenate(byArray4, byArray5);
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws InvalidCipherTextException {
        if (this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.d + 7 >> 3;
        int n3 = input.length - n2;
        byte[][] byArray = ByteUtils.split(input, n2);
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.d, byArray2);
        GF2Vector[] gF2VectorArray = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PrivateKeyParameters)this.a, gF2Vector);
        byte[] byArray4 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector2 = gF2VectorArray[1];
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray4);
        byte[] byArray5 = new byte[n3];
        digestRandomGenerator.nextBytes(byArray5);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray5[n4] = (byte)(byArray5[n4] ^ byArray3[i2]);
        }
        byte[] byArray6 = ByteUtils.concatenate(byArray4, byArray5);
        byte[] byArray7 = new byte[this.b.getDigestSize()];
        this.b.update(byArray6, 0, byArray6.length);
        this.b.doFinal(byArray7, 0);
        gF2Vector = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray7);
        if (!gF2Vector.equals(gF2Vector2)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray5;
    }
}

