/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.mceliece;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceParameters
implements CipherParameters {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int a;
    private int b;
    private int c;
    private int d;
    private Digest e;

    public McElieceParameters() {
        this(11, 50);
    }

    public McElieceParameters(Digest digest) {
        this(11, 50, digest);
    }

    public McElieceParameters(int keysize) {
        this(keysize, null);
    }

    public McElieceParameters(int keysize, Digest digest) {
        if (keysize < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        this.a = 0;
        this.c = 1;
        while (this.c < keysize) {
            this.c <<= 1;
            ++this.a;
        }
        this.b = this.c >>> 1;
        this.b /= this.a;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(this.a);
        this.e = digest;
    }

    public McElieceParameters(int m2, int t2) {
        this(m2, t2, null);
    }

    public McElieceParameters(int m2, int t2, Digest digest) {
        if (m2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m2 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.a = m2;
        this.c = 1 << m2;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.b = t2;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(m2);
        this.e = digest;
    }

    public McElieceParameters(int m2, int t2, int poly) {
        this(m2, t2, poly, null);
    }

    public McElieceParameters(int m2, int t2, int poly, Digest digest) {
        this.a = m2;
        if (m2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m2 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.c = 1 << m2;
        this.b = t2;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(poly) != m2 || !PolynomialRingGF2.isIrreducible(poly)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.d = poly;
        this.e = digest;
    }

    public int getM() {
        return this.a;
    }

    public int getN() {
        return this.c;
    }

    public int getT() {
        return this.b;
    }

    public int getFieldPoly() {
        return this.d;
    }
}

