/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.rainbow;

import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Layer {
    private int a;
    private int b;
    private int c;
    private short[][][] d;
    private short[][][] e;
    private short[][] f;
    private short[] g;

    public Layer(byte vi, byte viNext, short[][][] coeffAlpha, short[][][] coeffBeta, short[][] coeffGamma, short[] coeffEta) {
        this.a = vi & 0xFF;
        this.b = viNext & 0xFF;
        this.c = this.b - this.a;
        this.d = coeffAlpha;
        this.e = coeffBeta;
        this.f = coeffGamma;
        this.g = coeffEta;
    }

    public Layer(int vi, int viNext, SecureRandom sr) {
        int n2;
        int n3;
        int n4;
        this.a = vi;
        this.b = viNext;
        this.c = viNext - vi;
        this.d = new short[this.c][this.c][this.a];
        this.e = new short[this.c][this.a][this.a];
        this.f = new short[this.c][this.b];
        this.g = new short[this.c];
        int n5 = this.c;
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.c; ++n3) {
                for (n2 = 0; n2 < this.a; ++n2) {
                    this.d[n4][n3][n2] = (short)(sr.nextInt() & 0xFF);
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.a; ++n3) {
                for (n2 = 0; n2 < this.a; ++n2) {
                    this.e[n4][n3][n2] = (short)(sr.nextInt() & 0xFF);
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < this.b; ++n3) {
                this.f[n4][n3] = (short)(sr.nextInt() & 0xFF);
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            this.g[n4] = (short)(sr.nextInt() & 0xFF);
        }
    }

    public short[][] plugInVinegars(short[] x2) {
        int n2;
        int n3;
        int n4;
        short s2 = 0;
        short[][] sArray = new short[this.c][this.c + 1];
        short[] sArray2 = new short[this.c];
        for (n4 = 0; n4 < this.c; ++n4) {
            for (n3 = 0; n3 < this.a; ++n3) {
                for (n2 = 0; n2 < this.a; ++n2) {
                    s2 = GF2Field.multElem(this.e[n4][n3][n2], x2[n3]);
                    s2 = GF2Field.multElem(s2, x2[n2]);
                    sArray2[n4] = GF2Field.addElem(sArray2[n4], s2);
                }
            }
        }
        for (n4 = 0; n4 < this.c; ++n4) {
            for (n3 = 0; n3 < this.c; ++n3) {
                for (n2 = 0; n2 < this.a; ++n2) {
                    s2 = GF2Field.multElem(this.d[n4][n3][n2], x2[n2]);
                    sArray[n4][n3] = GF2Field.addElem(sArray[n4][n3], s2);
                }
            }
        }
        for (n4 = 0; n4 < this.c; ++n4) {
            for (n3 = 0; n3 < this.a; ++n3) {
                s2 = GF2Field.multElem(this.f[n4][n3], x2[n3]);
                sArray2[n4] = GF2Field.addElem(sArray2[n4], s2);
            }
        }
        for (n4 = 0; n4 < this.c; ++n4) {
            for (n3 = this.a; n3 < this.b; ++n3) {
                sArray[n4][n3 - this.a] = GF2Field.addElem(this.f[n4][n3], sArray[n4][n3 - this.a]);
            }
        }
        for (n4 = 0; n4 < this.c; ++n4) {
            sArray2[n4] = GF2Field.addElem(sArray2[n4], this.g[n4]);
        }
        for (n4 = 0; n4 < this.c; ++n4) {
            sArray[n4][this.c] = sArray2[n4];
        }
        return sArray;
    }

    public int getVi() {
        return this.a;
    }

    public int getViNext() {
        return this.b;
    }

    public int getOi() {
        return this.c;
    }

    public short[][][] getCoeffAlpha() {
        return this.d;
    }

    public short[][][] getCoeffBeta() {
        return this.e;
    }

    public short[][] getCoeffGamma() {
        return this.f;
    }

    public short[] getCoeffEta() {
        return this.g;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)other;
        return this.a == layer.getVi() && this.b == layer.getViNext() && this.c == layer.getOi() && RainbowUtil.equals(this.d, layer.getCoeffAlpha()) && RainbowUtil.equals(this.e, layer.getCoeffBeta()) && RainbowUtil.equals(this.f, layer.getCoeffGamma()) && RainbowUtil.equals(this.g, layer.getCoeffEta());
    }

    public int hashCode() {
        int n2 = this.a;
        n2 = n2 * 37 + this.b;
        n2 = n2 * 37 + this.c;
        n2 = n2 * 37 + Arrays.hashCode(this.d);
        n2 = n2 * 37 + Arrays.hashCode(this.e);
        n2 = n2 * 37 + Arrays.hashCode(this.f);
        n2 = n2 * 37 + Arrays.hashCode(this.g);
        return n2;
    }
}

