/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public final class XMSSMTPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters b;
    private final long c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private final byte[] g;
    private final BDSStateMap h;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true);
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getDigestSize();
        byte[] byArray = builder.h;
        if (byArray != null) {
            if (builder.i == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.b.getHeight();
            int n4 = (n3 + 7) / 8;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            this.c = XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
            if (!XMSSUtil.isIndexValid(n3, this.c)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
            this.e = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.f = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
            this.g = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
            try {
                BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray2, BDSStateMap.class);
                bDSStateMap.a(builder.i);
                this.h = bDSStateMap;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            this.c = builder.b;
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.d = byArray3;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray4 = builder.d;
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.e = byArray4;
            } else {
                this.e = new byte[n2];
            }
            byte[] byArray5 = builder.e;
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.f = byArray5;
            } else {
                this.f = new byte[n2];
            }
            byte[] byArray6 = builder.f;
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.g = byArray6;
            } else {
                this.g = new byte[n2];
            }
            BDSStateMap bDSStateMap = builder.g;
            if (bDSStateMap != null) {
                this.h = bDSStateMap;
            } else {
                long l2 = builder.b;
                int n10 = this.b.getHeight();
                this.h = XMSSUtil.isIndexValid(n10, l2) && byArray5 != null && byArray3 != null ? new BDSStateMap(this.b, builder.b, byArray5, byArray3) : new BDSStateMap();
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.b.getDigestSize();
        int n3 = (this.b.getHeight() + 7) / 8;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.c, n3);
        XMSSUtil.copyBytesAtOffset(byArray, byArray2, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n9 += n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.e, n9 += n4);
        XMSSUtil.copyBytesAtOffset(byArray, this.f, n9 += n5);
        XMSSUtil.copyBytesAtOffset(byArray, this.g, n9 += n6);
        try {
            return Arrays.concatenate(byArray, XMSSUtil.serialize(this.h));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("error serializing bds state: " + iOException.getMessage(), iOException);
        }
    }

    public long getIndex() {
        return this.c;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.e);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.f);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.g);
    }

    BDSStateMap a() {
        return this.h;
    }

    public XMSSMTParameters getParameters() {
        return this.b;
    }

    public XMSSMTPrivateKeyParameters getNextKey() {
        BDSStateMap bDSStateMap = new BDSStateMap(this.h, this.b, this.getIndex(), this.f, this.d);
        return new Builder(this.b).withIndex(this.c + 1L).withSecretKeySeed(this.d).withSecretKeyPRF(this.e).withPublicSeed(this.f).withRoot(this.g).withBDSState(bDSStateMap).build();
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private long b = 0L;
        private byte[] c = null;
        private byte[] d = null;
        private byte[] e = null;
        private byte[] f = null;
        private BDSStateMap g = null;
        private byte[] h = null;
        private XMSSParameters i = null;

        public Builder(XMSSMTParameters params) {
            this.a = params;
        }

        public Builder withIndex(long val) {
            this.b = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.e = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.f = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDSStateMap val) {
            this.g = val;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal, XMSSParameters xmssVal) {
            this.h = XMSSUtil.cloneArray(privateKeyVal);
            this.i = xmssVal;
            return this;
        }

        public XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this);
        }
    }
}

