/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.linearalgebra;

public final class ByteUtils {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        boolean bl = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            bl &= left[i2] == right[i2];
        }
        return bl;
    }

    public static boolean equals(byte[][] left, byte[][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean bl = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            bl &= ByteUtils.equals(left[i2], right[i2]);
        }
        return bl;
    }

    public static boolean equals(byte[][][] left, byte[][][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean bl = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            if (left[i2].length != right[i2].length) {
                return false;
            }
            for (int i3 = left[i2].length - 1; i3 >= 0; --i3) {
                bl &= ByteUtils.equals(left[i2][i3], right[i2][i3]);
            }
        }
        return bl;
    }

    public static int deepHashCode(byte[] array) {
        int n2 = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            n2 = 31 * n2 + array[i2];
        }
        return n2;
    }

    public static int deepHashCode(byte[][] array) {
        int n2 = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            n2 = 31 * n2 + ByteUtils.deepHashCode(array[i2]);
        }
        return n2;
    }

    public static int deepHashCode(byte[][][] array) {
        int n2 = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            n2 = 31 * n2 + ByteUtils.deepHashCode(array[i2]);
        }
        return n2;
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] byArray = new byte[array.length];
        System.arraycopy(array, 0, byArray, 0, array.length);
        return byArray;
    }

    public static byte[] fromHexString(String s2) {
        char[] cArray = s2.toUpperCase().toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if ((cArray[i2] < '0' || cArray[i2] > '9') && (cArray[i2] < 'A' || cArray[i2] > 'F')) continue;
            ++n2;
        }
        byte[] byArray = new byte[n2 + 1 >> 1];
        int n3 = n2 & 1;
        for (int i3 = 0; i3 < cArray.length; ++i3) {
            if (cArray[i3] >= '0' && cArray[i3] <= '9') {
                int n4 = n3 >> 1;
                byArray[n4] = (byte)(byArray[n4] << 4);
                int n5 = n3 >> 1;
                byArray[n5] = (byte)(byArray[n5] | cArray[i3] - 48);
            } else {
                if (cArray[i3] < 'A' || cArray[i3] > 'F') continue;
                int n6 = n3 >> 1;
                byArray[n6] = (byte)(byArray[n6] << 4);
                int n7 = n3 >> 1;
                byArray[n7] = (byte)(byArray[n7] | cArray[i3] - 65 + 10);
            }
            ++n3;
        }
        return byArray;
    }

    public static String toHexString(byte[] input) {
        String string = "";
        for (int i2 = 0; i2 < input.length; ++i2) {
            string = string + a[input[i2] >>> 4 & 0xF];
            string = string + a[input[i2] & 0xF];
        }
        return string;
    }

    public static String toHexString(byte[] input, String prefix, String seperator) {
        String string = new String(prefix);
        for (int i2 = 0; i2 < input.length; ++i2) {
            string = string + a[input[i2] >>> 4 & 0xF];
            string = string + a[input[i2] & 0xF];
            if (i2 >= input.length - 1) continue;
            string = string + seperator;
        }
        return string;
    }

    public static String toBinaryString(byte[] input) {
        String string = "";
        for (int i2 = 0; i2 < input.length; ++i2) {
            byte by = input[i2];
            for (int i3 = 0; i3 < 8; ++i3) {
                int n2 = by >>> i3 & 1;
                string = string + n2;
            }
            if (i2 == input.length - 1) continue;
            string = string + " ";
        }
        return string;
    }

    public static byte[] xor(byte[] x1, byte[] x2) {
        byte[] byArray = new byte[x1.length];
        for (int i2 = x1.length - 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)(x1[i2] ^ x2[i2]);
        }
        return byArray;
    }

    public static byte[] concatenate(byte[] x1, byte[] x2) {
        byte[] byArray = new byte[x1.length + x2.length];
        System.arraycopy(x1, 0, byArray, 0, x1.length);
        System.arraycopy(x2, 0, byArray, x1.length, x2.length);
        return byArray;
    }

    public static byte[] concatenate(byte[][] array) {
        int n2 = array[0].length;
        byte[] byArray = new byte[array.length * n2];
        int n3 = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            System.arraycopy(array[i2], 0, byArray, n3, n2);
            n3 += n2;
        }
        return byArray;
    }

    public static byte[][] split(byte[] input, int index) throws ArrayIndexOutOfBoundsException {
        if (index > input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] byArrayArray = new byte[][]{new byte[index], new byte[input.length - index]};
        System.arraycopy(input, 0, byArrayArray[0], 0, index);
        System.arraycopy(input, index, byArrayArray[1], 0, input.length - index);
        return byArrayArray;
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] byArray = new byte[end - start];
        System.arraycopy(input, start, byArray, 0, end - start);
        return byArray;
    }

    public static byte[] subArray(byte[] input, int start) {
        return ByteUtils.subArray(input, start, input.length);
    }

    public static char[] toCharArray(byte[] input) {
        char[] cArray = new char[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            cArray[i2] = (char)input[i2];
        }
        return cArray;
    }
}

