/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class GF2Vector
extends Vector {
    private int[] a;

    public GF2Vector(int length) {
        if (length < 0) {
            throw new ArithmeticException("Negative length.");
        }
        this.length = length;
        this.a = new int[length + 31 >> 5];
    }

    public GF2Vector(int length, SecureRandom sr) {
        int n2;
        this.length = length;
        int n3 = length + 31 >> 5;
        this.a = new int[n3];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.a[n2] = sr.nextInt();
        }
        n2 = length & 0x1F;
        if (n2 != 0) {
            int n4 = n3 - 1;
            this.a[n4] = this.a[n4] & (1 << n2) - 1;
        }
    }

    public GF2Vector(int length, int t2, SecureRandom sr) {
        int n2;
        if (t2 > length) {
            throw new ArithmeticException("The hamming weight is greater than the length of vector.");
        }
        this.length = length;
        int n3 = length + 31 >> 5;
        this.a = new int[n3];
        int[] nArray = new int[length];
        for (n2 = 0; n2 < length; ++n2) {
            nArray[n2] = n2;
        }
        n2 = length;
        for (int i2 = 0; i2 < t2; ++i2) {
            int n4 = RandUtils.a(sr, n2);
            this.setBit(nArray[n4]);
            nArray[n4] = nArray[--n2];
        }
    }

    public GF2Vector(int length, int[] v2) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        this.length = length;
        int n2 = length + 31 >> 5;
        if (v2.length != n2) {
            throw new ArithmeticException("length mismatch");
        }
        this.a = IntUtils.clone(v2);
        int n3 = length & 0x1F;
        if (n3 != 0) {
            int n4 = n2 - 1;
            this.a[n4] = this.a[n4] & (1 << n3) - 1;
        }
    }

    public GF2Vector(GF2Vector other) {
        this.length = other.length;
        this.a = IntUtils.clone(other.a);
    }

    protected GF2Vector(int[] v2, int length) {
        this.a = v2;
        this.length = length;
    }

    public static GF2Vector OS2VP(int length, byte[] encVec) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        int n2 = length + 7 >> 3;
        if (encVec.length > n2) {
            throw new ArithmeticException("length mismatch");
        }
        return new GF2Vector(length, LittleEndianConversions.toIntArray(encVec));
    }

    @Override
    public byte[] getEncoded() {
        int n2 = this.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(this.a, n2);
    }

    public int[] getVecArray() {
        return this.a;
    }

    public int getHammingWeight() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            int n3 = this.a[i2];
            for (int i3 = 0; i3 < 32; ++i3) {
                int n4 = n3 & 1;
                if (n4 != 0) {
                    ++n2;
                }
                n3 >>>= 1;
            }
        }
        return n2;
    }

    @Override
    public boolean isZero() {
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            if (this.a[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public int getBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = index >> 5;
        int n3 = index & 0x1F;
        return (this.a[n2] & 1 << n3) >>> n3;
    }

    public void setBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = index >> 5;
        this.a[n2] = this.a[n2] | 1 << (index & 0x1F);
    }

    @Override
    public Vector add(Vector other) {
        if (!(other instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        GF2Vector gF2Vector = (GF2Vector)other;
        if (this.length != gF2Vector.length) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = IntUtils.clone(((GF2Vector)other).a);
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            int n2 = i2;
            nArray[n2] = nArray[n2] ^ this.a[i2];
        }
        return new GF2Vector(this.length, nArray);
    }

    @Override
    public Vector multiply(Permutation p2) {
        int[] nArray = p2.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Vector gF2Vector = new GF2Vector(this.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = this.a[nArray[i2] >> 5] & 1 << (nArray[i2] & 0x1F);
            if (n2 == 0) continue;
            int n3 = i2 >> 5;
            gF2Vector.a[n3] = gF2Vector.a[n3] | 1 << (i2 & 0x1F);
        }
        return gF2Vector;
    }

    public GF2Vector extractVector(int[] setJ) {
        int n2 = setJ.length;
        if (setJ[n2 - 1] > this.length) {
            throw new ArithmeticException("invalid index set");
        }
        GF2Vector gF2Vector = new GF2Vector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.a[setJ[i2] >> 5] & 1 << (setJ[i2] & 0x1F);
            if (n3 == 0) continue;
            int n4 = i2 >> 5;
            gF2Vector.a[n4] = gF2Vector.a[n4] | 1 << (i2 & 0x1F);
        }
        return gF2Vector;
    }

    public GF2Vector extractLeftVector(int k2) {
        if (k2 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k2 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(k2);
        int n2 = k2 >> 5;
        int n3 = k2 & 0x1F;
        System.arraycopy(this.a, 0, gF2Vector.a, 0, n2);
        if (n3 != 0) {
            gF2Vector.a[n2] = this.a[n2] & (1 << n3) - 1;
        }
        return gF2Vector;
    }

    public GF2Vector extractRightVector(int k2) {
        if (k2 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k2 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(k2);
        int n2 = this.length - k2 >> 5;
        int n3 = this.length - k2 & 0x1F;
        int n4 = k2 + 31 >> 5;
        int n5 = n2;
        if (n3 != 0) {
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                gF2Vector.a[i2] = this.a[n5++] >>> n3 | this.a[n5] << 32 - n3;
            }
            gF2Vector.a[n4 - 1] = this.a[n5++] >>> n3;
            if (n5 < this.a.length) {
                int n6 = n4 - 1;
                gF2Vector.a[n6] = gF2Vector.a[n6] | this.a[n5] << 32 - n3;
            }
        } else {
            System.arraycopy(this.a, n2, gF2Vector.a, 0, n4);
        }
        return gF2Vector;
    }

    public GF2mVector toExtensionFieldVector(GF2mField field) {
        int n2 = field.getDegree();
        if (this.length % n2 != 0) {
            throw new ArithmeticException("conversion is impossible");
        }
        int n3 = this.length / n2;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            for (int i3 = field.getDegree() - 1; i3 >= 0; --i3) {
                int n5 = n4 >>> 5;
                int n6 = n4 & 0x1F;
                int n7 = this.a[n5] >>> n6 & 1;
                if (n7 == 1) {
                    int n8 = i2;
                    nArray[n8] = nArray[n8] ^ 1 << i3;
                }
                ++n4;
            }
        }
        return new GF2mVector(field, nArray);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2Vector)) {
            return false;
        }
        GF2Vector gF2Vector = (GF2Vector)other;
        return this.length == gF2Vector.length && IntUtils.equals(this.a, gF2Vector.a);
    }

    @Override
    public int hashCode() {
        int n2 = this.length;
        n2 = n2 * 31 + this.a.hashCode();
        return n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.length; ++i2) {
            int n2;
            int n3;
            int n4;
            if (i2 != 0 && (i2 & 0x1F) == 0) {
                stringBuffer.append(' ');
            }
            if ((n4 = this.a[n3 = i2 >> 5] & 1 << (n2 = i2 & 0x1F)) == 0) {
                stringBuffer.append('0');
                continue;
            }
            stringBuffer.append('1');
        }
        return stringBuffer.toString();
    }
}

