/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GFElement;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.math.BigInteger;
import java.util.Random;

public class GF2nPolynomialElement
extends GF2nElement {
    private static final int[] a = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0};
    private GF2Polynomial b;

    public GF2nPolynomialElement(GF2nPolynomialField f2, Random rand) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.b = new GF2Polynomial(this.mDegree);
        this.a(rand);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, GF2Polynomial bs) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.b = new GF2Polynomial(bs);
        this.b.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, byte[] os) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.b = new GF2Polynomial(this.mDegree, os);
        this.b.expandN(this.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialField f2, int[] is) {
        this.mField = f2;
        this.mDegree = this.mField.getDegree();
        this.b = new GF2Polynomial(this.mDegree, is);
        this.b.expandN(f2.mDegree);
    }

    public GF2nPolynomialElement(GF2nPolynomialElement other) {
        this.mField = other.mField;
        this.mDegree = other.mDegree;
        this.b = new GF2Polynomial(other.b);
    }

    @Override
    public Object clone() {
        return new GF2nPolynomialElement(this);
    }

    @Override
    void a() {
        this.b.assignZero();
    }

    public static GF2nPolynomialElement ZERO(GF2nPolynomialField f2) {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(f2.getDegree());
        return new GF2nPolynomialElement(f2, gF2Polynomial);
    }

    public static GF2nPolynomialElement ONE(GF2nPolynomialField f2) {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(f2.getDegree(), new int[]{1});
        return new GF2nPolynomialElement(f2, gF2Polynomial);
    }

    private void a(Random random) {
        this.b.expandN(this.mDegree);
        this.b.randomize(random);
    }

    @Override
    public boolean isZero() {
        return this.b.isZero();
    }

    @Override
    public boolean isOne() {
        return this.b.isOne();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomialElement)) {
            return false;
        }
        GF2nPolynomialElement gF2nPolynomialElement = (GF2nPolynomialElement)other;
        if (this.mField != gF2nPolynomialElement.mField && !this.mField.getFieldPolynomial().equals(gF2nPolynomialElement.mField.getFieldPolynomial())) {
            return false;
        }
        return this.b.equals(gF2nPolynomialElement.b);
    }

    @Override
    public int hashCode() {
        return this.mField.hashCode() + this.b.hashCode();
    }

    private GF2Polynomial b() {
        return new GF2Polynomial(this.b);
    }

    @Override
    boolean a(int n2) {
        return this.b.testBit(n2);
    }

    @Override
    public boolean testRightmostBit() {
        return this.b.testBit(0);
    }

    @Override
    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.addToThis(addend);
        return gF2nPolynomialElement;
    }

    @Override
    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)addend).mField)) {
            throw new RuntimeException();
        }
        this.b.addToThis(((GF2nPolynomialElement)addend).b);
    }

    @Override
    public GF2nElement increase() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.increaseThis();
        return gF2nPolynomialElement;
    }

    @Override
    public void increaseThis() {
        this.b.increaseThis();
    }

    @Override
    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.multiplyThisBy(factor);
        return gF2nPolynomialElement;
    }

    @Override
    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nPolynomialElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nPolynomialElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
            return;
        }
        this.b = this.b.multiply(((GF2nPolynomialElement)factor).b);
        this.d();
    }

    @Override
    public GFElement invert() throws ArithmeticException {
        return this.invertMAIA();
    }

    public GF2nPolynomialElement invertEEA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree + 32, "ONE");
        gF2Polynomial.reduceN();
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree + 32);
        gF2Polynomial2.reduceN();
        GF2Polynomial gF2Polynomial3 = this.b();
        GF2Polynomial gF2Polynomial4 = this.mField.getFieldPolynomial();
        gF2Polynomial3.reduceN();
        while (!gF2Polynomial3.isOne()) {
            gF2Polynomial3.reduceN();
            gF2Polynomial4.reduceN();
            int n2 = gF2Polynomial3.getLength() - gF2Polynomial4.getLength();
            if (n2 < 0) {
                GF2Polynomial gF2Polynomial5 = gF2Polynomial3;
                gF2Polynomial3 = gF2Polynomial4;
                gF2Polynomial4 = gF2Polynomial5;
                gF2Polynomial5 = gF2Polynomial;
                gF2Polynomial = gF2Polynomial2;
                gF2Polynomial2 = gF2Polynomial5;
                n2 = -n2;
                gF2Polynomial2.reduceN();
            }
            gF2Polynomial3.shiftLeftAddThis(gF2Polynomial4, n2);
            gF2Polynomial.shiftLeftAddThis(gF2Polynomial2, n2);
        }
        gF2Polynomial.reduceN();
        return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, gF2Polynomial);
    }

    public GF2nPolynomialElement invertSquare() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int n2 = this.mField.getDegree() - 1;
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.b.expandN((this.mDegree << 1) + 32);
        gF2nPolynomialElement.b.reduceN();
        int n3 = 1;
        for (int i2 = IntegerFunctions.floorLog(n2) - 1; i2 >= 0; --i2) {
            GF2nPolynomialElement gF2nPolynomialElement2 = new GF2nPolynomialElement(gF2nPolynomialElement);
            for (int i3 = 1; i3 <= n3; ++i3) {
                gF2nPolynomialElement2.squareThisPreCalc();
            }
            gF2nPolynomialElement.multiplyThisBy(gF2nPolynomialElement2);
            n3 <<= 1;
            if ((n2 & a[i2]) == 0) continue;
            gF2nPolynomialElement.squareThisPreCalc();
            gF2nPolynomialElement.multiplyThisBy(this);
            ++n3;
        }
        gF2nPolynomialElement.squareThisPreCalc();
        return gF2nPolynomialElement;
    }

    public GF2nPolynomialElement invertMAIA() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree, "ONE");
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree);
        GF2Polynomial gF2Polynomial3 = this.b();
        GF2Polynomial gF2Polynomial4 = this.mField.getFieldPolynomial();
        while (true) {
            if (!gF2Polynomial3.testBit(0)) {
                gF2Polynomial3.shiftRightThis();
                if (!gF2Polynomial.testBit(0)) {
                    gF2Polynomial.shiftRightThis();
                    continue;
                }
                gF2Polynomial.addToThis(this.mField.getFieldPolynomial());
                gF2Polynomial.shiftRightThis();
                continue;
            }
            if (gF2Polynomial3.isOne()) {
                return new GF2nPolynomialElement((GF2nPolynomialField)this.mField, gF2Polynomial);
            }
            gF2Polynomial3.reduceN();
            gF2Polynomial4.reduceN();
            if (gF2Polynomial3.getLength() < gF2Polynomial4.getLength()) {
                GF2Polynomial gF2Polynomial5 = gF2Polynomial3;
                gF2Polynomial3 = gF2Polynomial4;
                gF2Polynomial4 = gF2Polynomial5;
                gF2Polynomial5 = gF2Polynomial;
                gF2Polynomial = gF2Polynomial2;
                gF2Polynomial2 = gF2Polynomial5;
            }
            gF2Polynomial3.addToThis(gF2Polynomial4);
            gF2Polynomial.addToThis(gF2Polynomial2);
        }
    }

    @Override
    public GF2nElement square() {
        return this.squarePreCalc();
    }

    @Override
    public void squareThis() {
        this.squareThisPreCalc();
    }

    public GF2nPolynomialElement squareMatrix() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.squareThisMatrix();
        gF2nPolynomialElement.d();
        return gF2nPolynomialElement;
    }

    public void squareThisMatrix() {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree);
        for (int i2 = 0; i2 < this.mDegree; ++i2) {
            if (!this.b.vectorMult(((GF2nPolynomialField)this.mField).a[this.mDegree - i2 - 1])) continue;
            gF2Polynomial.setBit(i2);
        }
        this.b = gF2Polynomial;
    }

    public GF2nPolynomialElement squareBitwise() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.squareThisBitwise();
        gF2nPolynomialElement.d();
        return gF2nPolynomialElement;
    }

    public void squareThisBitwise() {
        this.b.squareThisBitwise();
        this.d();
    }

    public GF2nPolynomialElement squarePreCalc() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.squareThisPreCalc();
        gF2nPolynomialElement.d();
        return gF2nPolynomialElement;
    }

    public void squareThisPreCalc() {
        this.b.squareThisPreCalc();
        this.d();
    }

    public GF2nPolynomialElement power(int k2) {
        if (k2 == 1) {
            return new GF2nPolynomialElement(this);
        }
        GF2nPolynomialElement gF2nPolynomialElement = GF2nPolynomialElement.ONE((GF2nPolynomialField)this.mField);
        if (k2 == 0) {
            return gF2nPolynomialElement;
        }
        GF2nPolynomialElement gF2nPolynomialElement2 = new GF2nPolynomialElement(this);
        gF2nPolynomialElement2.b.expandN((gF2nPolynomialElement2.mDegree << 1) + 32);
        gF2nPolynomialElement2.b.reduceN();
        for (int i2 = 0; i2 < this.mDegree; ++i2) {
            if ((k2 & 1 << i2) != 0) {
                gF2nPolynomialElement.multiplyThisBy(gF2nPolynomialElement2);
            }
            gF2nPolynomialElement2.square();
        }
        return gF2nPolynomialElement;
    }

    @Override
    public GF2nElement squareRoot() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        gF2nPolynomialElement.squareRootThis();
        return gF2nPolynomialElement;
    }

    @Override
    public void squareRootThis() {
        this.b.expandN((this.mDegree << 1) + 32);
        this.b.reduceN();
        for (int i2 = 0; i2 < this.mField.getDegree() - 1; ++i2) {
            this.squareThis();
        }
    }

    @Override
    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        GF2nPolynomialElement gF2nPolynomialElement;
        GF2nPolynomialElement gF2nPolynomialElement2;
        if (this.isZero()) {
            return GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
        }
        if ((this.mDegree & 1) == 1) {
            return this.c();
        }
        do {
            GF2nPolynomialElement gF2nPolynomialElement3 = new GF2nPolynomialElement((GF2nPolynomialField)this.mField, new Random());
            gF2nPolynomialElement = GF2nPolynomialElement.ZERO((GF2nPolynomialField)this.mField);
            gF2nPolynomialElement2 = (GF2nPolynomialElement)gF2nPolynomialElement3.clone();
            for (int i2 = 1; i2 < this.mDegree; ++i2) {
                gF2nPolynomialElement.squareThis();
                gF2nPolynomialElement2.squareThis();
                gF2nPolynomialElement.addToThis(gF2nPolynomialElement2.multiply(this));
                gF2nPolynomialElement2.addToThis(gF2nPolynomialElement3);
            }
        } while (gF2nPolynomialElement2.isZero());
        if (!this.equals(gF2nPolynomialElement.square().add(gF2nPolynomialElement))) {
            throw new RuntimeException();
        }
        return gF2nPolynomialElement;
    }

    @Override
    public int trace() {
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        for (int i2 = 1; i2 < this.mDegree; ++i2) {
            gF2nPolynomialElement.squareThis();
            gF2nPolynomialElement.addToThis(this);
        }
        if (gF2nPolynomialElement.isOne()) {
            return 1;
        }
        return 0;
    }

    private GF2nPolynomialElement c() throws RuntimeException {
        if ((this.mDegree & 1) == 0) {
            throw new RuntimeException();
        }
        GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this);
        for (int i2 = 1; i2 <= this.mDegree - 1 >> 1; ++i2) {
            gF2nPolynomialElement.squareThis();
            gF2nPolynomialElement.squareThis();
            gF2nPolynomialElement.addToThis(this);
        }
        return gF2nPolynomialElement;
    }

    private void d() {
        if (this.b.getLength() > this.mDegree) {
            if (((GF2nPolynomialField)this.mField).isTrinomial()) {
                int n2;
                try {
                    n2 = ((GF2nPolynomialField)this.mField).getTc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a trinomial");
                }
                if (this.mDegree - n2 <= 32 || this.b.getLength() > this.mDegree << 1) {
                    this.b(n2);
                    return;
                }
                this.b.a(this.mDegree, n2);
                return;
            }
            if (((GF2nPolynomialField)this.mField).isPentanomial()) {
                int[] nArray;
                try {
                    nArray = ((GF2nPolynomialField)this.mField).getPc();
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("GF2nPolynomialElement.reduce: the field polynomial is not a pentanomial");
                }
                if (this.mDegree - nArray[2] <= 32 || this.b.getLength() > this.mDegree << 1) {
                    this.a(nArray);
                    return;
                }
                this.b.a(this.mDegree, nArray);
                return;
            }
            this.b = this.b.remainder(this.mField.getFieldPolynomial());
            this.b.expandN(this.mDegree);
            return;
        }
        if (this.b.getLength() < this.mDegree) {
            this.b.expandN(this.mDegree);
        }
    }

    private void b(int n2) {
        int n3 = this.mDegree - n2;
        for (int i2 = this.b.getLength() - 1; i2 >= this.mDegree; --i2) {
            if (!this.b.testBit(i2)) continue;
            this.b.xorBit(i2);
            this.b.xorBit(i2 - n3);
            this.b.xorBit(i2 - this.mDegree);
        }
        this.b.reduceN();
        this.b.expandN(this.mDegree);
    }

    private void a(int[] nArray) {
        int n2 = this.mDegree - nArray[2];
        int n3 = this.mDegree - nArray[1];
        int n4 = this.mDegree - nArray[0];
        for (int i2 = this.b.getLength() - 1; i2 >= this.mDegree; --i2) {
            if (!this.b.testBit(i2)) continue;
            this.b.xorBit(i2);
            this.b.xorBit(i2 - n2);
            this.b.xorBit(i2 - n3);
            this.b.xorBit(i2 - n4);
            this.b.xorBit(i2 - this.mDegree);
        }
        this.b.reduceN();
        this.b.expandN(this.mDegree);
    }

    @Override
    public String toString() {
        return this.b.toString(16);
    }

    @Override
    public String toString(int radix) {
        return this.b.toString(radix);
    }

    @Override
    public byte[] toByteArray() {
        return this.b.toByteArray();
    }

    @Override
    public BigInteger toFlexiBigInt() {
        return this.b.toFlexiBigInt();
    }
}

