/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.linearalgebra;

public final class PolynomialRingGF2 {
    private PolynomialRingGF2() {
    }

    public static int add(int p2, int q2) {
        return p2 ^ q2;
    }

    public static long multiply(int p2, int q2) {
        long l2 = 0L;
        if (q2 != 0) {
            long l3 = (long)q2 & 0xFFFFFFFFL;
            while (p2 != 0) {
                byte by = (byte)(p2 & 1);
                if (by == 1) {
                    l2 ^= l3;
                }
                p2 >>>= 1;
                l3 <<= 1;
            }
        }
        return l2;
    }

    public static int modMultiply(int a2, int b2, int r2) {
        int n2 = 0;
        int n3 = PolynomialRingGF2.remainder(a2, r2);
        int n4 = PolynomialRingGF2.remainder(b2, r2);
        if (n4 != 0) {
            int n5 = 1 << PolynomialRingGF2.degree(r2);
            while (n3 != 0) {
                byte by = (byte)(n3 & 1);
                if (by == 1) {
                    n2 ^= n4;
                }
                n3 >>>= 1;
                if ((n4 <<= 1) < n5) continue;
                n4 ^= r2;
            }
        }
        return n2;
    }

    public static int degree(int p2) {
        int n2 = -1;
        while (p2 != 0) {
            ++n2;
            p2 >>>= 1;
        }
        return n2;
    }

    public static int degree(long p2) {
        int n2 = 0;
        while (p2 != 0L) {
            ++n2;
            p2 >>>= 1;
        }
        return n2 - 1;
    }

    public static int remainder(int p2, int q2) {
        int n2 = p2;
        if (q2 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        while (PolynomialRingGF2.degree(n2) >= PolynomialRingGF2.degree(q2)) {
            n2 ^= q2 << PolynomialRingGF2.degree(n2) - PolynomialRingGF2.degree(q2);
        }
        return n2;
    }

    public static int rest(long p2, int q2) {
        long l2 = p2;
        if (q2 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        long l3 = (long)q2 & 0xFFFFFFFFL;
        while (l2 >>> 32 != 0L) {
            l2 ^= l3 << PolynomialRingGF2.degree(l2) - PolynomialRingGF2.degree(l3);
        }
        int n2 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        while (PolynomialRingGF2.degree(n2) >= PolynomialRingGF2.degree(q2)) {
            n2 ^= q2 << PolynomialRingGF2.degree(n2) - PolynomialRingGF2.degree(q2);
        }
        return n2;
    }

    public static int gcd(int p2, int q2) {
        int n2 = p2;
        int n3 = q2;
        while (n3 != 0) {
            int n4 = PolynomialRingGF2.remainder(n2, n3);
            n2 = n3;
            n3 = n4;
        }
        return n2;
    }

    public static boolean isIrreducible(int p2) {
        if (p2 == 0) {
            return false;
        }
        int n2 = PolynomialRingGF2.degree(p2) >>> 1;
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (PolynomialRingGF2.gcd((n3 = PolynomialRingGF2.modMultiply(n3, n3, p2)) ^ 2, p2) == 1) continue;
            return false;
        }
        return true;
    }

    public static int getIrreduciblePolynomial(int deg) {
        if (deg < 0) {
            System.err.println("The Degree is negative");
            return 0;
        }
        if (deg > 31) {
            System.err.println("The Degree is more then 31");
            return 0;
        }
        if (deg == 0) {
            return 1;
        }
        int n2 = 1 << deg;
        int n3 = 1 << deg + 1;
        for (int i2 = ++n2; i2 < n3; i2 += 2) {
            if (!PolynomialRingGF2.isIrreducible(i2)) continue;
            return i2;
        }
        return 0;
    }
}

