/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial;

import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public class ProductFormPolynomial
implements Polynomial {
    private SparseTernaryPolynomial a;
    private SparseTernaryPolynomial b;
    private SparseTernaryPolynomial c;

    public ProductFormPolynomial(SparseTernaryPolynomial f1, SparseTernaryPolynomial f2, SparseTernaryPolynomial f3) {
        this.a = f1;
        this.b = f2;
        this.c = f3;
    }

    public static ProductFormPolynomial generateRandom(int N, int df1, int df2, int df3Ones, int df3NegOnes, SecureRandom random) {
        SparseTernaryPolynomial sparseTernaryPolynomial = SparseTernaryPolynomial.generateRandom(N, df1, df1, random);
        SparseTernaryPolynomial sparseTernaryPolynomial2 = SparseTernaryPolynomial.generateRandom(N, df2, df2, random);
        SparseTernaryPolynomial sparseTernaryPolynomial3 = SparseTernaryPolynomial.generateRandom(N, df3Ones, df3NegOnes, random);
        return new ProductFormPolynomial(sparseTernaryPolynomial, sparseTernaryPolynomial2, sparseTernaryPolynomial3);
    }

    public static ProductFormPolynomial fromBinary(byte[] data, int N, int df1, int df2, int df3Ones, int df3NegOnes) throws IOException {
        return ProductFormPolynomial.fromBinary(new ByteArrayInputStream(data), N, df1, df2, df3Ones, df3NegOnes);
    }

    public static ProductFormPolynomial fromBinary(InputStream is, int N, int df1, int df2, int df3Ones, int df3NegOnes) throws IOException {
        SparseTernaryPolynomial sparseTernaryPolynomial = SparseTernaryPolynomial.fromBinary(is, N, df1, df1);
        SparseTernaryPolynomial sparseTernaryPolynomial2 = SparseTernaryPolynomial.fromBinary(is, N, df2, df2);
        SparseTernaryPolynomial sparseTernaryPolynomial3 = SparseTernaryPolynomial.fromBinary(is, N, df3Ones, df3NegOnes);
        return new ProductFormPolynomial(sparseTernaryPolynomial, sparseTernaryPolynomial2, sparseTernaryPolynomial3);
    }

    public byte[] toBinary() {
        byte[] byArray = this.a.toBinary();
        byte[] byArray2 = this.b.toBinary();
        byte[] byArray3 = this.c.toBinary();
        byte[] byArray4 = Arrays.copyOf(byArray, byArray.length + byArray2.length + byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial b2) {
        IntegerPolynomial integerPolynomial = this.a.mult(b2);
        integerPolynomial = this.b.mult(integerPolynomial);
        integerPolynomial.add(this.c.mult(b2));
        return integerPolynomial;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial b2) {
        BigIntPolynomial bigIntPolynomial = this.a.mult(b2);
        bigIntPolynomial = this.b.mult(bigIntPolynomial);
        bigIntPolynomial.add(this.c.mult(b2));
        return bigIntPolynomial;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        IntegerPolynomial integerPolynomial = this.a.mult(this.b.toIntegerPolynomial());
        integerPolynomial.add(this.c.toIntegerPolynomial());
        return integerPolynomial;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial integerPolynomial = this.mult(poly2);
        integerPolynomial.mod(modulus);
        return integerPolynomial;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductFormPolynomial productFormPolynomial = (ProductFormPolynomial)obj;
        if (this.a == null ? productFormPolynomial.a != null : !this.a.equals(productFormPolynomial.a)) {
            return false;
        }
        if (this.b == null ? productFormPolynomial.b != null : !this.b.equals(productFormPolynomial.b)) {
            return false;
        }
        return !(this.c == null ? productFormPolynomial.c != null : !this.c.equals(productFormPolynomial.c));
    }
}

