/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new TlsCertificate[0]);
    protected TlsCertificate[] certificateList;

    public Certificate(TlsCertificate[] certificateList) {
        if (certificateList == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateList;
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int index) {
        return this.certificateList[index];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream output) throws IOException {
        this.encode(null, output, null);
    }

    public void encode(TlsContext context, OutputStream messageOutput, OutputStream endPointHashOutput) throws IOException {
        Object object;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n3 = 0;
        for (n2 = 0; n2 < this.certificateList.length; ++n2) {
            object = this.certificateList[n2];
            byte[] byArray = object.getEncoded();
            if (n2 == 0 && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, (TlsCertificate)object, byArray, endPointHashOutput);
            }
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.checkUint24(n3);
        TlsUtils.writeUint24(n3, messageOutput);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24((byte[])object, messageOutput);
        }
    }

    public static Certificate parse(TlsContext context, InputStream input) throws IOException {
        return Certificate.parse(context, input, null);
    }

    public static Certificate parse(TlsContext context, InputStream messageInput, OutputStream endPointHashOutput) throws IOException {
        Object[] objectArray;
        int n2 = TlsUtils.readUint24(messageInput);
        if (n2 == 0) {
            return EMPTY_CHAIN;
        }
        byte[] byArray = TlsUtils.readFully(n2, messageInput);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<TlsCertificate> vector = new Vector<TlsCertificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream);
            TlsCertificate tlsCertificate = context.getCrypto().createCertificate((byte[])objectArray);
            if (vector.isEmpty() && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, tlsCertificate, objectArray, endPointHashOutput);
            }
            vector.addElement(tlsCertificate);
        }
        objectArray = new TlsCertificate[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            objectArray[i2] = (byte)((TlsCertificate)vector.elementAt(i2));
        }
        return new Certificate((TlsCertificate[])objectArray);
    }

    protected static void calculateEndPointHash(TlsContext context, TlsCertificate cert, byte[] encoding, OutputStream output) throws IOException {
        byte[] byArray = TlsUtils.a(context, cert.getSigAlgOID(), encoding);
        if (byArray != null && byArray.length > 0) {
            output.write(byArray);
        }
    }

    protected TlsCertificate[] cloneCertificateList() {
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, tlsCertificateArray, 0, tlsCertificateArray.length);
        return tlsCertificateArray;
    }
}

