/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateRequest {
    protected short[] certificateTypes;
    protected Vector supportedSignatureAlgorithms;
    protected Vector certificateAuthorities;

    public CertificateRequest(short[] certificateTypes, Vector supportedSignatureAlgorithms, Vector certificateAuthorities) {
        if (certificateTypes == null) {
            throw new IllegalArgumentException("'certificateTypes' cannot be null");
        }
        if (certificateTypes.length < 1 || !TlsUtils.isValidUint8(certificateTypes.length)) {
            throw new IllegalArgumentException("'certificateTypes' should have length from 1 to 255");
        }
        this.certificateTypes = certificateTypes;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
        this.certificateAuthorities = certificateAuthorities;
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public void encode(OutputStream output) throws IOException {
        if (this.certificateTypes == null || this.certificateTypes.length == 0) {
            TlsUtils.writeUint8(0, output);
        } else {
            TlsUtils.writeUint8ArrayWithUint8Length(this.certificateTypes, output);
        }
        if (this.supportedSignatureAlgorithms != null) {
            TlsUtils.encodeSupportedSignatureAlgorithms(this.supportedSignatureAlgorithms, false, output);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            Object object;
            int n2;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n3 = 0;
            for (n2 = 0; n2 < this.certificateAuthorities.size(); ++n2) {
                object = (X500Name)this.certificateAuthorities.elementAt(n2);
                byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                vector.addElement(byArray);
                n3 += byArray.length + 2;
            }
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (byte[])vector.elementAt(n2);
                TlsUtils.writeOpaque16((byte[])object, output);
            }
        }
    }

    public static CertificateRequest parse(TlsContext context, InputStream input) throws IOException {
        int n2 = TlsUtils.readUint8(input);
        if (n2 < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(input);
        }
        Vector vector = null;
        if (TlsUtils.isTLSv12(context)) {
            vector = TlsUtils.parseSupportedSignatureAlgorithms(false, input);
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        byte[] byArray = TlsUtils.readOpaque16(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray2);
            vector2.addElement(X500Name.getInstance(aSN1Primitive));
        }
        return new CertificateRequest(sArray, vector, vector2);
    }
}

