/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CipherSuite;
import com.enterprisedt.bouncycastle.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.tls.o;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean verifyRequests) {
        this.verifyRequests = verifyRequests;
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 0;
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.a = server;
        serverHandshakeState.b = new o(server.getCrypto(), securityParameters);
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(server.shouldUseGMTUnixTime(), serverHandshakeState.b);
        securityParameters.l = server.shouldUseExtendedPadding();
        server.init(serverHandshakeState.b);
        e e2 = new e(transport, serverHandshakeState.b, server, 22);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, e2);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, e2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, e2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, e2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState state, e recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState state, e recordLayer) throws IOException {
        Object object;
        byte[] byArray;
        byte[] byArray2;
        Object object2;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        f f2 = new f(state.b, recordLayer);
        f.a a2 = f2.d();
        if (a2.b() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(state, a2.c());
        this.invalidateSession(state);
        state.c = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
        state.d = null;
        Object object3 = this.generateServerHello(state);
        DTLSServerProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        Object object4 = state.b.getServerVersion();
        recordLayer.a((ProtocolVersion)object4);
        recordLayer.b((ProtocolVersion)object4);
        f2.a((short)2, (byte[])object3);
        f2.a();
        object3 = state.a.getServerSupplementalData();
        if (object3 != null) {
            object4 = DTLSServerProtocol.generateSupplementalData((Vector)object3);
            f2.a((short)23, (byte[])object4);
        }
        state.n = state.a.getKeyExchange();
        state.n.init(state.b);
        state.o = TlsProtocol.validateCredentials(state.a.getCredentials());
        object4 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (state.o == null) {
            state.n.skipServerCredentials();
        } else {
            state.n.processServerCredentials(state.o);
            object4 = state.o.getCertificate();
            object2 = DTLSServerProtocol.generateCertificate(state.b, (Certificate)object4, byteArrayOutputStream);
            f2.a((short)11, (byte[])object2);
        }
        securityParameters.h = byteArrayOutputStream.toByteArray();
        if (object4 == null || ((Certificate)object4).isEmpty()) {
            state.l = false;
        }
        if (state.l && (object2 = (Object)state.a.getCertificateStatus()) != null) {
            byArray2 = this.generateCertificateStatus(state, (CertificateStatus)object2);
            f2.a((short)22, byArray2);
        }
        if ((object2 = state.n.generateServerKeyExchange()) != null) {
            f2.a((short)12, (byte[])object2);
        }
        if (state.o != null) {
            state.p = state.a.getCertificateRequest();
            if (state.p != null) {
                if (TlsUtils.isTLSv12(state.b) != (state.p.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                state.p = TlsUtils.a(state.p, state.n);
                byArray2 = this.generateCertificateRequest(state, state.p);
                f2.a((short)13, byArray2);
                TlsUtils.a(f2.b(), state.p.getSupportedSignatureAlgorithms());
            }
        }
        f2.a((short)14, TlsUtils.EMPTY_BYTES);
        boolean bl = false;
        TlsUtils.b(state.b, f2.b(), bl);
        a2 = f2.d();
        if (a2.b() == 23) {
            this.processClientSupplementalData(state, a2.c());
            a2 = f2.d();
        } else {
            state.a.processClientSupplementalData(null);
        }
        if (state.p == null) {
            state.n.skipClientCredentials();
        } else if (a2.b() == 11) {
            this.processClientCertificate(state, a2.c());
            a2 = f2.d();
        } else {
            if (TlsUtils.isTLSv12(state.b)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(state, Certificate.EMPTY_CHAIN);
        }
        if (a2.b() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(state, a2.c());
        TlsHandshakeHash tlsHandshakeHash = f2.c();
        securityParameters.e = TlsUtils.a(tlsHandshakeHash);
        TlsProtocol.establishMasterSecret(state.b, state.n);
        recordLayer.a(state.a.getCipher());
        if (this.expectCertificateVerifyMessage(state)) {
            byArray = f2.a((short)15);
            this.processCertificateVerify(state, byArray, tlsHandshakeHash);
        }
        byArray = this.createVerifyData(state.b, f2, false);
        this.processFinished(f2.a((short)20), byArray);
        if (state.m) {
            object = state.a.getNewSessionTicket();
            byte[] byArray3 = this.generateNewSessionTicket(state, (NewSessionTicket)object);
            f2.a((short)4, byArray3);
        }
        object = this.createVerifyData(state.b, f2, true);
        f2.a((short)20, (byte[])object);
        f2.e();
        state.d = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setLocalCertificate((Certificate)object4).setMasterSecret(state.b.getCrypto().adoptSecret(securityParameters.getMasterSecret())).setNegotiatedVersion(state.b.getServerVersion()).setPeerCertificate(state.q).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.i).build();
        state.c = TlsUtils.importSession(state.c.getSessionID(), state.d);
        securityParameters.i = byArray;
        state.b.a(state.c);
        state.a.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState state, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState state, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState state, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState state) throws IOException {
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = state.a.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(state.b.getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        state.b.setServerVersion(protocolVersion);
        TlsUtils.writeVersion(state.b.getServerVersion(), byteArrayOutputStream);
        byteArrayOutputStream.write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8(state.c.getSessionID(), byteArrayOutputStream);
        int n2 = state.a.getSelectedCipherSuite();
        if (!Arrays.contains(state.f, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, state.b.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        DTLSServerProtocol.validateSelectedCipherSuite(n2, (short)80);
        securityParameters.cipherSuite = n2;
        short s2 = state.a.getSelectedCompressionMethod();
        if (!Arrays.contains(state.g, s2)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.b = s2;
        TlsUtils.writeUint16(n2, byteArrayOutputStream);
        TlsUtils.writeUint8(s2, (OutputStream)byteArrayOutputStream);
        state.i = state.a.getServerExtensions();
        if (state.k) {
            boolean bl;
            byte[] byArray = TlsUtils.getExtensionData(state.i, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl2 = bl = null == byArray;
            if (bl) {
                state.i = TlsExtensionsUtils.ensureExtensionsInitialised(state.i);
                state.i.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            state.i = TlsExtensionsUtils.ensureExtensionsInitialised(state.i);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.i);
        }
        if (state.i != null) {
            securityParameters.j = TlsExtensionsUtils.hasEncryptThenMACExtension(state.i);
            securityParameters.c = DTLSServerProtocol.evaluateMaxFragmentLengthExtension(state.j, state.h, state.i, (short)80);
            securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension(state.i);
            state.l = !state.j && TlsUtils.hasExpectedEmptyExtensionData(state.i, TlsExtensionsUtils.EXT_status_request, (short)80);
            state.m = !state.j && TlsUtils.hasExpectedEmptyExtensionData(state.i, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsProtocol.writeExtensions(byteArrayOutputStream, state.i);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(state.b, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState state) {
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        if (state.c != null) {
            state.c.invalidate();
            state.c = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState state, Certificate clientCertificate) throws IOException {
        if (state.p == null) {
            throw new IllegalStateException();
        }
        if (state.q != null) {
            throw new TlsFatalAlert(10);
        }
        state.q = clientCertificate;
        if (clientCertificate.isEmpty()) {
            state.n.skipClientCredentials();
        } else {
            state.n.processClientCertificate(clientCertificate);
        }
        state.a.notifyClientCertificate(clientCertificate);
    }

    protected void processClientCertificate(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Certificate certificate = Certificate.parse(state.b, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(state, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState state, byte[] body, TlsHandshakeHash prepareFinishHash) throws IOException {
        if (state.p == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        o o2 = state.b;
        DigitallySigned digitallySigned = DigitallySigned.parse(o2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.a((TlsContext)o2, state.p, state.q, digitallySigned, prepareFinishHash);
    }

    protected void processClientHello(ServerHandshakeState state, byte[] body) throws IOException {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray3.length > 32) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray4 = TlsUtils.readOpaque8(byteArrayInputStream);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        state.f = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        state.g = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        state.h = TlsProtocol.readExtensions(byteArrayInputStream);
        o o2 = state.b;
        SecurityParameters securityParameters = o2.getSecurityParameters();
        securityParameters.k = TlsExtensionsUtils.hasExtendedMasterSecretExtension(state.h);
        o2.setClientVersion(protocolVersion);
        state.a.notifyClientVersion(protocolVersion);
        state.a.notifyFallback(Arrays.contains(state.f, 22016));
        securityParameters.clientRandom = byArray2;
        state.a.notifyOfferedCipherSuites(state.f);
        state.a.notifyOfferedCompressionMethods(state.g);
        if (Arrays.contains(state.f, 255)) {
            state.k = true;
        }
        if ((byArray = TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            state.k = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.a.notifySecureRenegotiation(state.k);
        if (state.h != null) {
            TlsExtensionsUtils.getPaddingExtension(state.h);
            state.a.processClientExtensions(state.h);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.n.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState state) {
        Certificate certificate = state.q;
        return certificate != null && !certificate.isEmpty() && state.n.requiresCertificateVerify();
    }

    protected static class ServerHandshakeState {
        TlsServer a = null;
        o b = null;
        TlsSession c = null;
        SessionParameters d = null;
        SessionParameters.Builder e = null;
        int[] f = null;
        short[] g = null;
        Hashtable h = null;
        Hashtable i = null;
        boolean j = false;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        TlsKeyExchange n = null;
        TlsCredentials o = null;
        CertificateRequest p = null;
        Certificate q = null;

        protected ServerHandshakeState() {
        }
    }
}

