/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsServer;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47};
    protected int[] supportedCipherSuites;

    public DefaultTlsServer(TlsCrypto crypto) {
        super(crypto);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    public DefaultTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto, keyExchangeFactory);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 11: 
            case 20: {
                return null;
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n2);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n2);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

