/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ocsp.ResponderID;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class OCSPStatusRequest {
    protected Vector responderIDList;
    protected Extensions requestExtensions;

    public OCSPStatusRequest(Vector responderIDList, Extensions requestExtensions) {
        this.responderIDList = responderIDList;
        this.requestExtensions = requestExtensions;
    }

    public Vector getResponderIDList() {
        return this.responderIDList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void encode(OutputStream output) throws IOException {
        Object object;
        if (this.responderIDList == null || this.responderIDList.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            object = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < this.responderIDList.size(); ++i2) {
                ResponderID responderID = (ResponderID)this.responderIDList.elementAt(i2);
                byte[] byArray = responderID.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, (OutputStream)object);
            }
            TlsUtils.checkUint16(((ByteArrayOutputStream)object).size());
            TlsUtils.writeUint16(((ByteArrayOutputStream)object).size(), output);
            Streams.writeBufTo((ByteArrayOutputStream)object, output);
        }
        if (this.requestExtensions == null) {
            TlsUtils.writeUint16(0, output);
        } else {
            object = this.requestExtensions.getEncoded("DER");
            TlsUtils.checkUint16(((Object)object).length);
            TlsUtils.writeUint16(((Object)object).length, output);
            output.write((byte[])object);
        }
    }

    public static OCSPStatusRequest parse(InputStream input) throws IOException {
        Object object;
        Vector<ResponderID> vector = new Vector<ResponderID>();
        int n2 = TlsUtils.readUint16(input);
        if (n2 > 0) {
            byte[] byArray = TlsUtils.readFully(n2, input);
            object = new ByteArrayInputStream(byArray);
            do {
                byte[] byArray2 = TlsUtils.readOpaque16((InputStream)object);
                ResponderID responderID = ResponderID.getInstance(TlsUtils.readDERObject(byArray2));
                vector.addElement(responderID);
            } while (((ByteArrayInputStream)object).available() > 0);
        }
        Extensions extensions = null;
        int n3 = TlsUtils.readUint16(input);
        if (n3 > 0) {
            object = TlsUtils.readFully(n3, input);
            extensions = Extensions.getInstance(TlsUtils.readDERObject((byte[])object));
        }
        return new OCSPStatusRequest(vector, extensions);
    }
}

