/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtocolName {
    public static final ProtocolName HTTP_1_1 = ProtocolName.asUtf8Encoding("http/1.1");
    public static final ProtocolName SPDY_1 = ProtocolName.asUtf8Encoding("spdy/1");
    public static final ProtocolName SPDY_2 = ProtocolName.asUtf8Encoding("spdy/2");
    public static final ProtocolName SPDY_3 = ProtocolName.asUtf8Encoding("spdy/3");
    public static final ProtocolName STUN_TURN = ProtocolName.asUtf8Encoding("stun.turn");
    public static final ProtocolName STUN_NAT_DISCOVERY = ProtocolName.asUtf8Encoding("stun.nat-discovery");
    public static final ProtocolName HTTP_2_TLS = ProtocolName.asUtf8Encoding("h2");
    public static final ProtocolName HTTP_2_TCP = ProtocolName.asUtf8Encoding("h2c");
    public static final ProtocolName WEBRTC = ProtocolName.asUtf8Encoding("webrtc");
    public static final ProtocolName WEBRTC_CONFIDENTIAL = ProtocolName.asUtf8Encoding("c-webrtc");
    public static final ProtocolName FTP = ProtocolName.asUtf8Encoding("ftp");
    public static final ProtocolName IMAP = ProtocolName.asUtf8Encoding("imap");
    public static final ProtocolName POP3 = ProtocolName.asUtf8Encoding("pop3");
    public static final ProtocolName MANAGESIEVE = ProtocolName.asUtf8Encoding("managesieve");
    public static final ProtocolName COAP = ProtocolName.asUtf8Encoding("coap");
    public static final ProtocolName XMPP_CLIENT = ProtocolName.asUtf8Encoding("xmpp-client");
    public static final ProtocolName XMPP_SERVER = ProtocolName.asUtf8Encoding("xmpp-server");
    private final byte[] a;

    public static final ProtocolName asRawBytes(byte[] bytes) {
        return new ProtocolName(Arrays.clone(bytes));
    }

    public static final ProtocolName asUtf8Encoding(String name) {
        return new ProtocolName(Strings.toUTF8ByteArray(name));
    }

    private ProtocolName(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("'bytes' cannot be null");
        }
        if (bytes.length < 1 || bytes.length > 255) {
            throw new IllegalArgumentException("'bytes' must have length from 1 to 255");
        }
        this.a = bytes;
    }

    public byte[] getBytes() {
        return Arrays.clone(this.a);
    }

    public String getUtf8Decoding() {
        return Strings.fromUTF8ByteArray(this.a);
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(this.a, output);
    }

    public static ProtocolName parse(InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque8(input);
        if (byArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return new ProtocolName(byArray);
    }

    public boolean equals(Object obj) {
        return obj instanceof ProtocolName && Arrays.areEqual(this.a, ((ProtocolName)obj).a);
    }

    public int hashCode() {
        return Arrays.hashCode(this.a);
    }
}

