/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsSRPUtils;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ServerSRPParams {
    protected BigInteger N;
    protected BigInteger g;
    protected BigInteger B;
    protected byte[] s;

    public ServerSRPParams(BigInteger N, BigInteger g2, byte[] s2, BigInteger B) {
        this.N = N;
        this.g = g2;
        this.s = Arrays.clone(s2);
        this.B = B;
    }

    public BigInteger getB() {
        return this.B;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getN() {
        return this.N;
    }

    public byte[] getS() {
        return this.s;
    }

    public void encode(OutputStream output) throws IOException {
        TlsSRPUtils.writeSRPParameter(this.N, output);
        TlsSRPUtils.writeSRPParameter(this.g, output);
        TlsUtils.writeOpaque8(this.s, output);
        TlsSRPUtils.writeSRPParameter(this.B, output);
    }

    public static ServerSRPParams parse(InputStream input) throws IOException {
        BigInteger bigInteger = TlsSRPUtils.readSRPParameter(input);
        BigInteger bigInteger2 = TlsSRPUtils.readSRPParameter(input);
        byte[] byArray = TlsUtils.readOpaque8(input);
        BigInteger bigInteger3 = TlsSRPUtils.readSRPParameter(input);
        return new ServerSRPParams(bigInteger, bigInteger2, byArray, bigInteger3);
    }
}

