/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CipherSuite;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContextImpl;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.a;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl a = null;
    protected byte[] selectedSessionID = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        SessionParameters sessionParameters;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.a = 1;
        this.a = new TlsClientContextImpl(tlsClient.getCrypto(), this.securityParameters);
        this.securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(tlsClient.shouldUseGMTUnixTime(), this.a);
        this.securityParameters.l = tlsClient.shouldUseExtendedPadding();
        this.tlsClient.init(this.a);
        this.b.a(this.a);
        TlsSession tlsSession = tlsClient.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null) {
            this.tlsSession = tlsSession;
            this.sessionParameters = sessionParameters;
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.selectedSessionID = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.a;
    }

    @Override
    a a() {
        return this.a;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    @Override
    protected void handleHandshakeMessage(short type, ByteArrayInputStream buf) throws IOException {
        if (this.resumedSession) {
            if (type != 20 || this.connection_state != 2) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            this.connection_state = (short)15;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)13;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        this.peerCertificate = Certificate.parse(this.getContext(), buf, byteArrayOutputStream);
                        TlsClientProtocol.assertEmpty(buf);
                        this.securityParameters.h = byteArrayOutputStream.toByteArray();
                        if (this.peerCertificate == null || this.peerCertificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        this.authentication = this.tlsClient.getAuthentication();
                        if (this.authentication != null) break;
                        throw new TlsFatalAlert(80);
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 4: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 13: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 14: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(buf);
                        this.connection_state = (short)2;
                        this.b.g();
                        this.applyMaxFragmentLengthExtension();
                        if (this.resumedSession) {
                            this.securityParameters.d = this.getContext().getCrypto().adoptSecret(this.sessionParameters.getMasterSecret());
                            this.b.a(this.getPeer().getCompression(), this.getPeer().getCipher());
                            break block0;
                        }
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(this.selectedSessionID, null);
                        this.sessionParameters = null;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: 
                    case 7: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)9;
                        TlsCredentials tlsCredentials = null;
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            tlsCredentials = TlsClientProtocol.validateCredentials(this.authentication.getClientCredentials(this.certificateRequest));
                            if (tlsCredentials == null) {
                                this.keyExchange.skipClientCredentials();
                                this.sendCertificateMessage(Certificate.EMPTY_CHAIN, null);
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                this.sendCertificateMessage(tlsCredentials.getCertificate(), null);
                                if (tlsCredentials instanceof TlsCredentialedSigner) {
                                    tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                    tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                }
                            }
                        }
                        this.connection_state = (short)10;
                        boolean bl = tlsStreamSigner != null;
                        TlsUtils.b(this.getContext(), this.b.h(), bl);
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)11;
                        TlsHandshakeHash tlsHandshakeHash = this.b.j();
                        this.securityParameters.e = TlsUtils.a(tlsHandshakeHash);
                        TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        this.b.a(this.getPeer().getCompression(), this.getPeer().getCipher());
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.a(this.getContext(), tlsCredentialedSigner, tlsStreamSigner, tlsHandshakeHash);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)12;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)13;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse(this.getContext(), buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.certificateRequest = TlsUtils.a(this.certificateRequest, this.keyExchange);
                        TlsUtils.a(this.b.h(), this.certificateRequest.getSupportedSignatureAlgorithms());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)14;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (this.connection_state != 16) break;
                this.refuseRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        if (this.authentication == null) {
            this.securityParameters.h = TlsUtils.EMPTY_BYTES;
            this.keyExchange.skipServerCredentials();
        } else {
            TlsUtils.a(this.peerCertificate, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
        }
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)3;
        this.keyExchange = this.tlsClient.getKeyExchange();
        this.keyExchange.init(this.getContext());
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        Serializable serializable;
        Object object;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(buf);
        if (!TlsUtils.isTLSv10(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
        if (!protocolVersion.equals(this.b.b())) {
            throw new TlsFatalAlert(47);
        }
        ProtocolVersion protocolVersion2 = this.getContext().getClientVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(protocolVersion2)) {
            throw new TlsFatalAlert(47);
        }
        this.b.b(protocolVersion);
        this.a().setServerVersion(protocolVersion);
        this.tlsClient.notifyServerVersion(protocolVersion);
        this.securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        this.selectedSessionID = TlsUtils.readOpaque8(buf);
        if (this.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySessionID(this.selectedSessionID);
        this.resumedSession = this.selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual(this.selectedSessionID, this.tlsSession.getSessionID());
        int n2 = TlsUtils.readUint16(buf);
        if (!Arrays.contains(this.offeredCipherSuites, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8(buf);
        if (!Arrays.contains(this.offeredCompressionMethods, s2)) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCompressionMethod(s2);
        this.serverExtensions = TlsClientProtocol.readExtensions(buf);
        if (this.serverExtensions != null) {
            object = this.serverExtensions.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(this.secure_renegotiation);
        object = this.clientExtensions;
        serializable = this.serverExtensions;
        if (this.resumedSession) {
            if (n2 != this.sessionParameters.getCipherSuite() || s2 != this.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = this.sessionParameters.readServerExtensions();
        }
        this.securityParameters.cipherSuite = n2;
        this.securityParameters.b = s2;
        if (serializable != null) {
            boolean bl = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl && !TlsUtils.isBlockCipherSuite(n2)) {
                throw new TlsFatalAlert(47);
            }
            this.securityParameters.j = bl;
            this.securityParameters.k = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            this.securityParameters.c = this.processMaxFragmentLengthExtension((Hashtable)object, (Hashtable)serializable, (short)47);
            this.securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            this.tlsClient.processServerExtensions((Hashtable)serializable);
        }
        this.securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(this, 15);
        certificateVerify.encode(a2);
        a2.a();
    }

    protected void sendClientHelloMessage() throws IOException {
        boolean bl;
        this.b.b(this.tlsClient.getClientHelloRecordLayerVersion());
        ProtocolVersion protocolVersion = this.tlsClient.getClientVersion();
        if (!TlsUtils.isTLSv10(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.a().setClientVersion(protocolVersion);
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (this.tlsSession != null && ((byArray = this.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        boolean bl2 = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        if (!(byArray.length <= 0 || this.sessionParameters == null || Arrays.contains(this.offeredCipherSuites, this.sessionParameters.getCipherSuite()) && Arrays.contains(this.offeredCompressionMethods, this.sessionParameters.getCompressionAlgorithm()))) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = this.tlsClient.getClientExtensions();
        TlsProtocol.a a2 = new TlsProtocol.a(this, 1);
        TlsUtils.writeVersion(protocolVersion, a2);
        a2.write(this.securityParameters.getClientRandom());
        TlsUtils.writeOpaque8(byArray, a2);
        byte[] byArray2 = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        boolean bl3 = null == byArray2;
        boolean bl4 = bl = !Arrays.contains(this.offeredCipherSuites, 255);
        if (bl3 && bl) {
            this.offeredCipherSuites = Arrays.append(this.offeredCipherSuites, 255);
        }
        if (bl2 && !Arrays.contains(this.offeredCipherSuites, 22016)) {
            this.offeredCipherSuites = Arrays.append(this.offeredCipherSuites, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.offeredCipherSuites, a2);
        TlsUtils.writeUint8ArrayWithUint8Length(this.offeredCompressionMethods, a2);
        if (this.clientExtensions != null) {
            TlsClientProtocol.writeExtensions(a2, this.clientExtensions);
        }
        a2.a();
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(this, 16);
        this.keyExchange.generateClientKeyExchange(a2);
        a2.a();
    }
}

