/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.DHStandardGroups;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class TlsDHUtils {
    public static boolean containsDHECipherSuites(int[] cipherSuites) {
        for (int i2 = 0; i2 < cipherSuites.length; ++i2) {
            if (!TlsDHUtils.isDHECipherSuite(cipherSuites[i2])) continue;
            return true;
        }
        return false;
    }

    public static TlsDHConfig createNamedDHConfig(int namedGroup) {
        return NamedGroup.getFiniteFieldBits(namedGroup) > 0 ? new TlsDHConfig(namedGroup) : null;
    }

    public static DHGroup getDHGroup(TlsDHConfig dhConfig) {
        int n2 = dhConfig.getNamedGroup();
        if (n2 >= 0) {
            return TlsDHUtils.getNamedDHGroup(n2);
        }
        return dhConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static int getMinimumFiniteFieldBits(int cipherSuite) {
        return TlsDHUtils.isDHECipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isDHECipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static int getNamedGroupForDHParameters(BigInteger p2, BigInteger g2) {
        int[] nArray = new int[]{256, 257, 258, 259, 260};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            DHGroup dHGroup = TlsDHUtils.getNamedDHGroup(n2);
            if (dHGroup == null || !dHGroup.getP().equals(p2) || !dHGroup.getG().equals(g2)) continue;
            return n2;
        }
        return -1;
    }

    public static TlsDHConfig readDHConfig(InputStream input) throws IOException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(input);
        int n2 = TlsDHUtils.getNamedGroupForDHParameters(bigInteger2, bigInteger = TlsDHUtils.readDHParameter(input));
        if (n2 >= 0) {
            return new TlsDHConfig(n2);
        }
        return new TlsDHConfig(new DHGroup(bigInteger2, null, bigInteger, 0));
    }

    public static TlsDHConfig receiveDHConfig(TlsDHConfigVerifier dhConfigVerifier, InputStream input) throws IOException {
        TlsDHConfig tlsDHConfig = TlsDHUtils.readDHConfig(input);
        if (!dhConfigVerifier.accept(tlsDHConfig)) {
            throw new TlsFatalAlert(71);
        }
        return tlsDHConfig;
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input));
    }

    public static void writeDHConfig(TlsDHConfig dhConfig, OutputStream output) throws IOException {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(dhConfig);
        TlsDHUtils.writeDHParameter(dHGroup.getP(), output);
        TlsDHUtils.writeDHParameter(dHGroup.getG(), output);
    }

    public static void writeDHParameter(BigInteger x2, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x2), output);
    }
}

