/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsECConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class TlsECCUtils {
    public static final Integer EXT_ec_point_formats = Integers.valueOf(11);

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_ec_point_formats);
        return byArray == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null || !Arrays.contains(ecPointFormats, (short)0)) {
            ecPointFormats = Arrays.append(ecPointFormats, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(ecPointFormats);
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionData) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (!Arrays.contains(sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static boolean containsECCipherSuites(int[] cipherSuites) {
        for (int i2 = 0; i2 < cipherSuites.length; ++i2) {
            if (!TlsECCUtils.isECCipherSuite(cipherSuites[i2])) continue;
            return true;
        }
        return false;
    }

    public static int getMinimumCurveBits(int cipherSuite) {
        return TlsECCUtils.isECCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isECCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static short getCompressionFormat(int namedGroup) throws IOException {
        if (NamedGroup.isPrimeCurve(namedGroup)) {
            return 1;
        }
        if (NamedGroup.isChar2Curve(namedGroup)) {
            return 2;
        }
        throw new TlsFatalAlert(47);
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, int namedGroup) throws IOException {
        return TlsECCUtils.isCompressionPreferred(peerECPointFormats, TlsECCUtils.getCompressionFormat(namedGroup));
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, short compressionFormat) {
        if (peerECPointFormats == null || compressionFormat == 0) {
            return false;
        }
        for (int i2 = 0; i2 < peerECPointFormats.length; ++i2) {
            short s2 = peerECPointFormats[i2];
            if (s2 == 0) {
                return false;
            }
            if (s2 != compressionFormat) continue;
            return true;
        }
        return false;
    }

    public static void checkPointEncoding(short[] localECPointFormats, int namedGroup, byte[] encoding) throws IOException {
        if (encoding == null || encoding.length < 1) {
            throw new TlsFatalAlert(47);
        }
        short s2 = TlsECCUtils.getActualFormat(namedGroup, encoding);
        TlsECCUtils.checkActualFormat(localECPointFormats, s2);
    }

    public static void checkActualFormat(short[] localECPointFormats, short actualFormat) throws IOException {
        if (!(actualFormat == 0 || localECPointFormats != null && Arrays.contains(localECPointFormats, actualFormat))) {
            throw new TlsFatalAlert(47);
        }
    }

    public static short getActualFormat(int namedGroup, byte[] encoding) throws IOException {
        switch (encoding[0]) {
            case 2: 
            case 3: {
                return TlsECCUtils.getCompressionFormat(namedGroup);
            }
            case 4: {
                return 0;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig readECConfig(short[] peerECPointFormats, InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (s2 != 3) {
            throw new TlsFatalAlert(40);
        }
        int n2 = TlsUtils.readUint16(input);
        if (!NamedGroup.refersToASpecificCurve(n2)) {
            throw new TlsFatalAlert(47);
        }
        boolean bl = TlsECCUtils.isCompressionPreferred(peerECPointFormats, n2);
        TlsECConfig tlsECConfig = new TlsECConfig();
        tlsECConfig.setNamedGroup(n2);
        tlsECConfig.setPointCompression(bl);
        return tlsECConfig;
    }

    public static TlsECConfig receiveECConfig(TlsECConfigVerifier ecConfigVerifier, short[] peerECPointFormats, InputStream input) throws IOException {
        TlsECConfig tlsECConfig = TlsECCUtils.readECConfig(peerECPointFormats, input);
        if (!ecConfigVerifier.accept(tlsECConfig)) {
            throw new TlsFatalAlert(47);
        }
        return tlsECConfig;
    }

    public static void writeECConfig(TlsECConfig ecConfig, OutputStream output) throws IOException {
        TlsECCUtils.writeNamedECParameters(ecConfig.getNamedGroup(), output);
    }

    public static void writeNamedECParameters(int namedGroup, OutputStream output) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedGroup);
        TlsUtils.writeUint16(namedGroup, output);
    }
}

