/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ByteQueue;
import com.enterprisedt.bouncycastle.tls.ByteQueueInputStream;
import com.enterprisedt.bouncycastle.tls.ByteQueueOutputStream;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.tls.RecordPreview;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.SupplementalDataEntry;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedAgreement;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlertReceived;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsNoCloseNotifyException;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.j;
import com.enterprisedt.bouncycastle.tls.l;
import com.enterprisedt.bouncycastle.tls.m;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_CERTIFICATE_STATUS = 5;
    protected static final short CS_SERVER_KEY_EXCHANGE = 6;
    protected static final short CS_CERTIFICATE_REQUEST = 7;
    protected static final short CS_SERVER_HELLO_DONE = 8;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 9;
    protected static final short CS_CLIENT_CERTIFICATE = 10;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 11;
    protected static final short CS_CERTIFICATE_VERIFY = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_FINISHED = 15;
    protected static final short CS_END = 16;
    protected static final short ADS_MODE_1_Nsub1 = 0;
    protected static final short ADS_MODE_0_N = 1;
    protected static final short ADS_MODE_0_N_FIRSTONLY = 2;
    private ByteQueue a = new ByteQueue(0);
    private ByteQueue c = new ByteQueue(2);
    private ByteQueue d = new ByteQueue(0);
    j b;
    private l e = null;
    private m f = null;
    private volatile boolean g = false;
    private volatile boolean h = false;
    private volatile boolean i = false;
    private volatile boolean j = true;
    private volatile boolean k = false;
    private volatile int l = 0;
    private byte[] m = null;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected SecurityParameters securityParameters = null;
    protected Certificate localCertificate = null;
    protected Certificate peerCertificate = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean resumedSession = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean secure_renegotiation = false;
    protected boolean allowCertificateStatus = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    protected TlsProtocol() {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.b = new j(this, this.inputBuffers, this.outputBuffer);
    }

    protected TlsProtocol(InputStream input, OutputStream output) {
        this.blocking = true;
        this.b = new j(this, input, output);
    }

    public void resumeHandshake() throws IOException {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use resumeHandshake() in non-blocking mode!");
        }
        if (!this.isHandshaking()) {
            throw new IllegalStateException("No handshake in progress");
        }
        this.blockForHandshake();
    }

    protected void closeConnection() throws IOException {
        this.b.k();
    }

    protected abstract TlsContext getContext();

    abstract com.enterprisedt.bouncycastle.tls.a a();

    protected abstract TlsPeer getPeer();

    protected void handleAlertMessage(short alertLevel, short alertDescription) throws IOException {
        this.getPeer().notifyAlertReceived(alertLevel, alertDescription);
        if (alertLevel != 1) {
            this.handleFailure();
            throw new TlsFatalAlertReceived(alertDescription);
        }
        this.handleAlertWarningMessage(alertDescription);
    }

    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        if (alertDescription == 0) {
            if (!this.i) {
                throw new TlsFatalAlert(40);
            }
            this.handleClose(false);
        }
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.g) {
            this.g = true;
            if (user_canceled && !this.i) {
                this.raiseAlertWarning((short)90, "User canceled handshake");
            }
            this.raiseAlertWarning((short)0, "Connection closed");
            if (!this.i) {
                this.cleanupHandshake();
            }
            this.closeConnection();
        }
    }

    protected void handleException(short alertDescription, String message, Throwable e2) throws IOException {
        if ((this.i || this.isResumableHandshake()) && e2 instanceof InterruptedIOException) {
            return;
        }
        if (!this.g) {
            this.raiseAlertFatal(alertDescription, message, e2);
            this.handleFailure();
        }
    }

    protected void handleFailure() throws IOException {
        this.g = true;
        this.h = true;
        this.invalidateSession();
        if (!this.i) {
            this.cleanupHandshake();
        }
        this.closeConnection();
    }

    protected abstract void handleHandshakeMessage(short var1, ByteArrayInputStream var2) throws IOException;

    protected void applyMaxFragmentLengthExtension() throws IOException {
        short s2 = this.securityParameters.getMaxFragmentLength();
        if (s2 >= 0) {
            if (!MaxFragmentLength.isValid(s2)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + s2;
            this.b.a(n2);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean expected) throws IOException {
        if (expected != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void blockForHandshake() throws IOException {
        while (this.connection_state != 16) {
            if (this.isClosed()) {
                throw new TlsFatalAlert(80);
            }
            this.safeReadRecord();
        }
    }

    protected void cleanupHandshake() {
        if (this.m != null) {
            Arrays.fill(this.m, (byte)0);
            this.m = null;
        }
        this.tlsSession = null;
        this.sessionParameters = null;
        this.securityParameters.a();
        this.localCertificate = null;
        this.peerCertificate = null;
        this.offeredCipherSuites = null;
        this.offeredCompressionMethods = null;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.resumedSession = false;
        this.receivedChangeCipherSpec = false;
        this.secure_renegotiation = false;
        this.allowCertificateStatus = false;
        this.expectSessionTicket = false;
    }

    protected void completeHandshake() throws IOException {
        try {
            this.connection_state = (short)16;
            this.c.shrink();
            this.d.shrink();
            this.b.e();
            boolean bl = this.j = !TlsUtils.isTLSv11(this.getContext());
            if (!this.i) {
                this.i = true;
                if (this.blocking) {
                    this.e = new l(this);
                    this.f = new m(this);
                }
            }
            if (this.sessionParameters == null) {
                this.sessionParameters = new SessionParameters.Builder().setCipherSuite(this.securityParameters.getCipherSuite()).setCompressionAlgorithm(this.securityParameters.getCompressionAlgorithm()).setLocalCertificate(this.localCertificate).setMasterSecret(this.getContext().getCrypto().adoptSecret(this.securityParameters.getMasterSecret())).setNegotiatedVersion(this.getContext().getServerVersion()).setPeerCertificate(this.peerCertificate).setPSKIdentity(this.securityParameters.getPSKIdentity()).setSRPIdentity(this.securityParameters.getSRPIdentity()).setServerExtensions(this.serverExtensions).build();
                this.tlsSession = TlsUtils.importSession(this.tlsSession.getSessionID(), this.sessionParameters);
            }
            this.a().a(this.tlsSession);
            this.getPeer().notifyHandshakeComplete();
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short protocol, byte[] buf, int off, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.c.addData(buf, off, len);
                this.c();
                break;
            }
            case 23: {
                if (!this.i) {
                    throw new TlsFatalAlert(10);
                }
                this.a.addData(buf, off, len);
                this.b();
                break;
            }
            case 20: {
                this.a(buf, off, len);
                break;
            }
            case 22: {
                if (this.d.available() > 0) {
                    this.d.addData(buf, off, len);
                    this.a(this.d);
                    break;
                }
                ByteQueue byteQueue = new ByteQueue(buf, off, len);
                this.a(byteQueue);
                int n2 = byteQueue.available();
                if (n2 <= 0) break;
                this.d.addData(buf, off + len - n2, n2);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    private void a(ByteQueue byteQueue) throws IOException {
        while (byteQueue.available() >= 4) {
            Object object;
            byte[] byArray = new byte[4];
            byteQueue.read(byArray, 0, 4, 0);
            short s2 = TlsUtils.readUint8(byArray, 0);
            int n2 = TlsUtils.readUint24(byArray, 1);
            int n3 = 4 + n2;
            if (byteQueue.available() < n3) break;
            this.checkReceivedChangeCipherSpec(this.connection_state == 16 || s2 == 20);
            switch (s2) {
                case 0: {
                    break;
                }
                case 20: {
                    object = this.getContext();
                    if (this.m == null && object.getSecurityParameters().getMasterSecret() != null) {
                        this.m = this.createVerifyData(!object.isServer());
                    }
                }
                default: {
                    byteQueue.copyTo(this.b.i(), n3);
                }
            }
            byteQueue.removeData(4);
            object = byteQueue.readFrom(n2);
            this.handleHandshakeMessage(s2, (ByteArrayInputStream)object);
        }
    }

    private void b() {
    }

    private void c() throws IOException {
        while (this.c.available() >= 2) {
            byte[] byArray = this.c.removeData(2, 0);
            short s2 = byArray[0];
            short s3 = byArray[1];
            this.handleAlertMessage(s2, s3);
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            short s2 = TlsUtils.readUint8(byArray, n2 + i2);
            if (s2 != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.c.available() > 0 || this.d.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.b.d();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    public int applicationDataAvailable() {
        return this.a.available();
    }

    public int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        while (this.a.available() == 0) {
            if (this.g) {
                if (this.h) {
                    throw new IOException("Cannot read application data on failed TLS connection");
                }
                return -1;
            }
            if (!this.i) {
                throw new IllegalStateException("Cannot read application data until initial handshake completed.");
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.a.available());
        this.a.removeData(buf, offset, len, 0);
        return len;
    }

    protected RecordPreview safePreviewRecordHeader(byte[] recordHeader) throws IOException {
        try {
            return this.b.a(recordHeader, this.i);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (this.b.f()) {
                return;
            }
            if (!this.i) {
                throw new TlsFatalAlert(40);
            }
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    protected boolean safeReadFullRecord(byte[] input, int inputOff, int inputLen) throws IOException {
        try {
            return this.b.a(input, inputOff, inputLen);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to process record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to process record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to process record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.b.b(type, buf, offset, len);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to write record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to write record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to write record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    public void writeApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (this.g) {
            throw new IOException("Cannot write application data on closed/failed TLS connection");
        }
        if (!this.i) {
            throw new IllegalStateException("Cannot write application data until initial handshake completed.");
        }
        while (len > 0) {
            if (this.j) {
                switch (this.getAppDataSplitMode()) {
                    case 2: {
                        this.j = false;
                    }
                    case 1: {
                        this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
                        break;
                    }
                    default: {
                        this.safeWriteRecord((short)23, buf, offset, 1);
                        ++offset;
                        --len;
                    }
                }
            }
            if (len <= 0) continue;
            int n2 = Math.min(len, this.b.a());
            this.safeWriteRecord((short)23, buf, offset, n2);
            offset += n2;
            len -= n2;
        }
    }

    public int getAppDataSplitMode() {
        return this.l;
    }

    public void setAppDataSplitMode(int appDataSplitMode) {
        if (appDataSplitMode < 0 || appDataSplitMode > 2) {
            throw new IllegalArgumentException("Illegal appDataSplitMode mode: " + appDataSplitMode);
        }
        this.l = appDataSplitMode;
    }

    public boolean isResumableHandshake() {
        return this.k;
    }

    public void setResumableHandshake(boolean resumableHandshake) {
        this.k = resumableHandshake;
    }

    protected void writeHandshakeMessage(byte[] buf, int off, int len) throws IOException {
        int n2;
        if (len < 4) {
            throw new TlsFatalAlert(80);
        }
        short s2 = TlsUtils.readUint8(buf, off);
        if (s2 != 0) {
            this.b.i().write(buf, off, len);
        }
        int n3 = 0;
        do {
            n2 = Math.min(len - n3, this.b.a());
            this.safeWriteRecord((short)22, buf, off + n3, n2);
        } while ((n3 += n2) < len);
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.f;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.e;
    }

    public void closeInput() throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use closeInput() in blocking mode!");
        }
        if (this.g) {
            return;
        }
        if (this.inputBuffers.available() > 0) {
            throw new EOFException();
        }
        if (!this.i) {
            throw new TlsFatalAlert(40);
        }
        throw new TlsNoCloseNotifyException();
    }

    public RecordPreview previewInputRecord(byte[] recordHeader) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewInputRecord() in blocking mode!");
        }
        if (this.inputBuffers.available() != 0) {
            throw new IllegalStateException("Can only use previewInputRecord() for record-aligned input.");
        }
        if (this.g) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        return this.safePreviewRecordHeader(recordHeader);
    }

    public RecordPreview previewOutputRecord(int applicationDataSize) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        if (this.outputBuffer.getBuffer().available() != 0) {
            throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
        }
        if (this.g) {
            throw new IOException("Connection is closed, cannot produce any more output");
        }
        if (applicationDataSize < 1) {
            return new RecordPreview(0, 0);
        }
        if (this.j) {
            switch (this.getAppDataSplitMode()) {
                case 1: 
                case 2: {
                    RecordPreview recordPreview = this.b.b(0);
                    RecordPreview recordPreview2 = this.b.b(applicationDataSize);
                    return RecordPreview.a(recordPreview, recordPreview2);
                }
            }
            RecordPreview recordPreview = this.b.b(1);
            if (applicationDataSize > 1) {
                RecordPreview recordPreview3 = this.b.b(applicationDataSize - 1);
                recordPreview = RecordPreview.a(recordPreview, recordPreview3);
            }
            return recordPreview;
        }
        return this.b.b(applicationDataSize);
    }

    public void offerInput(byte[] input) throws IOException {
        this.offerInput(input, 0, input.length);
    }

    public void offerInput(byte[] input, int inputOff, int inputLen) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.g) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        if (this.inputBuffers.available() == 0 && this.safeReadFullRecord(input, inputOff, inputLen)) {
            if (this.g && this.connection_state != 16) {
                throw new TlsFatalAlert(80);
            }
            return;
        }
        this.inputBuffers.addBytes(input, inputOff, inputLen);
        while (this.inputBuffers.available() >= 5) {
            byte[] byArray = new byte[5];
            if (5 != this.inputBuffers.peek(byArray)) {
                throw new TlsFatalAlert(80);
            }
            RecordPreview recordPreview = this.safePreviewRecordHeader(byArray);
            if (this.inputBuffers.available() < recordPreview.getRecordSize()) break;
            this.safeReadRecord();
            if (!this.g) continue;
            if (this.connection_state == 16) break;
            throw new TlsFatalAlert(80);
        }
    }

    public int getApplicationDataLimit() {
        return this.b.a();
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((length = Math.min(length, this.a.available())) < 1) {
            return 0;
        }
        this.a.removeData(buffer, offset, length, 0);
        return length;
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n2 = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, offset, n2, 0);
        return n2;
    }

    protected void invalidateSession() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
            this.tlsSession = null;
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        if (this.m == null) {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray = TlsUtils.readFully(this.m.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual(this.m, byArray)) {
            throw new TlsFatalAlert(51);
        }
        if (null == this.securityParameters.getTLSUnique()) {
            this.securityParameters.i = byArray;
        }
    }

    protected void raiseAlertFatal(short alertDescription, String message, Throwable cause) throws IOException {
        this.getPeer().notifyAlertRaised((short)2, alertDescription, message, cause);
        byte[] byArray = new byte[]{2, (byte)alertDescription};
        try {
            this.b.b((short)21, byArray, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void raiseAlertWarning(short alertDescription, String message) throws IOException {
        this.getPeer().notifyAlertRaised((short)1, alertDescription, message, null);
        byte[] byArray = new byte[]{1, (byte)alertDescription};
        this.safeWriteRecord((short)21, byArray, 0, 2);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        this.sendCertificateMessage(certificate, null);
    }

    protected void sendCertificateMessage(Certificate certificate, OutputStream endPointHash) throws IOException {
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        a a2 = new a(11);
        certificate.encode(this.getContext(), a2, endPointHash);
        a2.a();
        this.localCertificate = certificate;
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] byArray = new byte[]{1};
        this.safeWriteRecord((short)20, byArray, 0, byArray.length);
        this.b.c();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] byArray = this.createVerifyData(this.getContext().isServer());
        a a2 = new a(20, byArray.length);
        a2.write(byArray);
        a2.a();
        if (null == this.securityParameters.getTLSUnique()) {
            this.securityParameters.i = byArray;
        }
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        a a2 = new a(23);
        TlsProtocol.writeSupplementalData(a2, supplementalData);
        a2.a();
    }

    protected byte[] createVerifyData(boolean isServer) {
        return TlsUtils.a(this.getContext(), this.b.h(), isServer);
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    public void flush() throws IOException {
        this.b.l();
    }

    public boolean isClosed() {
        return this.g;
    }

    public boolean isHandshaking() {
        return this.securityParameters != null && this.connection_state != 16 && !this.isClosed();
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short s2 = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (s2 >= 0 && (!MaxFragmentLength.isValid(s2) || !this.resumedSession && s2 != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return s2;
    }

    protected void refuseRenegotiation() throws IOException {
        this.raiseAlertWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean useGMTUnixTime, TlsContext context) {
        byte[] byArray = context.getNonceGenerator().generateNonce(32);
        if (useGMTUnixTime) {
            TlsUtils.writeGMTUnixTime(byArray, 0);
        }
        return byArray;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        TlsSecret tlsSecret = keyExchange.generatePreMasterSecret();
        if (tlsSecret == null) {
            throw new TlsFatalAlert(80);
        }
        try {
            context.getSecurityParameters().d = TlsUtils.calculateMasterSecret(context, tlsSecret);
        }
        finally {
            tlsSecret.destroy();
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] byArray = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2;
            Integer n2 = Integers.valueOf(TlsUtils.readUint16(byteArrayInputStream));
            if (null == hashtable.put(n2, byArray2 = TlsUtils.readOpaque16(byteArrayInputStream))) continue;
            throw new TlsFatalAlert(47);
        }
        return hashtable;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque24(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<SupplementalDataEntry> vector = new Vector<SupplementalDataEntry>();
        while (byteArrayInputStream.available() > 0) {
            int n2 = TlsUtils.readUint16(byteArrayInputStream);
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            vector.addElement(new SupplementalDataEntry(n2, byArray2));
        }
        return vector;
    }

    protected static TlsCredentials validateCredentials(TlsCredentials credentials) throws IOException {
        if (credentials != null) {
            int n2 = 0;
            n2 += credentials instanceof TlsCredentialedAgreement ? 1 : 0;
            n2 += credentials instanceof TlsCredentialedDecryptor ? 1 : 0;
            if ((n2 += credentials instanceof TlsCredentialedSigner ? 1 : 0) != 1) {
                throw new TlsFatalAlert(80);
            }
        }
        return credentials;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, extensions, true);
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, extensions, false);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque16(byArray, output);
    }

    protected static void writeSelectedExtensions(OutputStream output, Hashtable extensions, boolean selectEmpty) throws IOException {
        Enumeration enumeration = extensions.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            byte[] byArray = (byte[])extensions.get(n2);
            if (selectEmpty != (byArray.length == 0)) continue;
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            TlsUtils.writeOpaque16(byArray, output);
        }
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < supplementalData.size(); ++i2) {
            SupplementalDataEntry supplementalDataEntry = (SupplementalDataEntry)supplementalData.elementAt(i2);
            int n2 = supplementalDataEntry.getDataType();
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
            TlsUtils.writeOpaque16(supplementalDataEntry.getData(), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque24(byArray, output);
    }

    protected static int getPRFAlgorithm(TlsContext context, int cipherSuite) throws IOException {
        boolean bl = TlsUtils.isTLSv12(context);
        switch (cipherSuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49258: 
            case 49260: 
            case 49262: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                if (bl) {
                    return 1;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49259: 
            case 49261: 
            case 49263: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: 
            case 53250: {
                if (bl) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (bl) {
                    return 2;
                }
                return 0;
            }
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    class a
    extends ByteArrayOutputStream {
        a(short s2) throws IOException {
            this(s2, 60);
        }

        a(short s2, int n2) throws IOException {
            super(n2 + 4);
            TlsUtils.writeUint8(s2, (OutputStream)this);
            this.count += 3;
        }

        void a() throws IOException {
            int n2 = this.count - 4;
            TlsUtils.checkUint24(n2);
            TlsUtils.writeUint24(n2, this.buf, 1);
            TlsProtocol.this.writeHandshakeMessage(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

