/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CipherSuite;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.a;
import com.enterprisedt.bouncycastle.tls.o;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    o a = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.a = 0;
        this.a = new o(tlsServer.getCrypto(), this.securityParameters);
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(tlsServer.shouldUseGMTUnixTime(), this.a);
        this.securityParameters.l = tlsServer.shouldUseExtendedPadding();
        this.tlsServer.init(this.a);
        this.b.a(this.a);
        this.b.a(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.a;
    }

    @Override
    a a() {
        return this.a;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    @Override
    protected void handleHandshakeMessage(short type, ByteArrayInputStream buf) throws IOException {
        block0 : switch (type) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        Object object;
                        this.receiveClientHelloMessage(buf);
                        this.connection_state = 1;
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
                        this.sessionParameters = null;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.b.g();
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = TlsServerProtocol.validateCredentials(this.tlsServer.getCredentials());
                        Certificate certificate = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            certificate = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage(certificate, byteArrayOutputStream);
                        }
                        this.securityParameters.h = byteArrayOutputStream.toByteArray();
                        this.connection_state = (short)4;
                        if (certificate == null || certificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                        }
                        this.connection_state = (short)5;
                        object = this.keyExchange.generateServerKeyExchange();
                        if (object != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                if (TlsUtils.isTLSv12(this.getContext()) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.a(this.certificateRequest, this.keyExchange);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.a(this.b.h(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        boolean bl = false;
                        TlsUtils.b(this.getContext(), this.b.h(), bl);
                        break block0;
                    }
                    case 16: {
                        this.refuseRenegotiation();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(buf));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(buf);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.getContext())) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 10: {
                        this.receiveClientKeyExchangeMessage(buf);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(buf);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        super.handleAlertWarningMessage(alertDescription);
        switch (alertDescription) {
            case 41: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.peerCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.peerCertificate = clientCertificate;
        if (clientCertificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.keyExchange.processClientCertificate(clientCertificate);
        }
        this.tlsServer.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream buf) throws IOException {
        Certificate certificate = Certificate.parse(this.getContext(), buf, null);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream buf) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        TlsContext tlsContext = this.getContext();
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsContext, buf);
        TlsServerProtocol.assertEmpty(buf);
        TlsUtils.a(tlsContext, this.certificateRequest, this.peerCertificate, digitallySigned, this.prepareFinishHash);
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream buf) throws IOException {
        byte[] byArray;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(buf);
        this.b.b(protocolVersion);
        if (protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)buf);
        byte[] byArray3 = TlsUtils.readOpaque8(buf);
        if (byArray3.length > 32) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16(buf);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(n2 / 2, buf);
        short s2 = TlsUtils.readUint8(buf);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(s2, buf);
        this.clientExtensions = TlsServerProtocol.readExtensions(buf);
        this.securityParameters.k = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        this.a().setClientVersion(protocolVersion);
        this.tlsServer.notifyClientVersion(protocolVersion);
        this.tlsServer.notifyFallback(Arrays.contains(this.offeredCipherSuites, 22016));
        this.securityParameters.clientRandom = byArray2;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (Arrays.contains(this.offeredCipherSuites, 255)) {
            this.secure_renegotiation = true;
        }
        if ((byArray = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream buf) throws IOException {
        this.keyExchange.processClientKeyExchange(buf);
        TlsServerProtocol.assertEmpty(buf);
        this.prepareFinishHash = this.b.j();
        this.securityParameters.e = TlsUtils.a(this.prepareFinishHash);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.b.a(this.getPeer().getCompression(), this.getPeer().getCipher());
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(13);
        certificateRequest.encode(a2);
        a2.a();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(22);
        certificateStatus.encode(a2);
        a2.a();
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.a a2 = new TlsProtocol.a(4);
        newSessionTicket.encode(a2);
        a2.a();
    }

    protected void sendServerHelloMessage() throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(2);
        ProtocolVersion protocolVersion = this.tlsServer.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.b.a(protocolVersion);
        this.b.b(protocolVersion);
        this.b.a(true);
        this.a().setServerVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, a2);
        a2.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(this.tlsSession.getSessionID(), a2);
        int n2 = this.tlsServer.getSelectedCipherSuite();
        if (!Arrays.contains(this.offeredCipherSuites, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.cipherSuite = n2;
        short s2 = this.tlsServer.getSelectedCompressionMethod();
        if (!Arrays.contains(this.offeredCompressionMethods, s2)) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.b = s2;
        TlsUtils.writeUint16(n2, a2);
        TlsUtils.writeUint8(s2, (OutputStream)a2);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean bl;
            byte[] byArray = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl2 = bl = null == byArray;
            if (bl) {
                this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.securityParameters.isExtendedMasterSecret()) {
            this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        }
        if (this.serverExtensions != null) {
            this.securityParameters.j = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            this.securityParameters.c = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            this.securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsServerProtocol.writeExtensions(a2, this.serverExtensions);
        }
        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        a2.a();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)14, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.writeHandshakeMessage(byArray, 0, byArray.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] serverKeyExchange) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(12, serverKeyExchange.length);
        a2.write(serverKeyExchange);
        a2.a();
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.peerCertificate != null && !this.peerCertificate.isEmpty() && this.keyExchange.requiresCertificateVerify();
    }
}

