/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CombinedHash;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.tls.MACAlgorithm;
import com.enterprisedt.bouncycastle.tls.PRFAlgorithm;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.SignatureAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.tls.n;
import com.enterprisedt.bouncycastle.tls.p;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    private static final Hashtable c = TlsUtils.a();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    protected static short MINIMUM_HASH_STRICT = (short)2;
    protected static short MINIMUM_HASH_PREFERRED = (short)4;
    static final byte[] a = new byte[]{67, 76, 78, 84};
    static final byte[] b = new byte[]{83, 82, 86, 82};

    private static void a(Hashtable hashtable, ASN1ObjectIdentifier aSN1ObjectIdentifier, short s2) {
        hashtable.put(aSN1ObjectIdentifier.getId(), s2);
    }

    private static Hashtable a() {
        Hashtable hashtable = new Hashtable();
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha224, (short)3);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha256, (short)4);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha384, (short)5);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha512, (short)6);
        TlsUtils.a(hashtable, OIWObjectIdentifiers.dsaWithSHA1, (short)2);
        TlsUtils.a(hashtable, OIWObjectIdentifiers.md5WithRSA, (short)1);
        TlsUtils.a(hashtable, OIWObjectIdentifiers.sha1WithRSA, (short)2);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.md5WithRSAEncryption, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1, (short)2);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, (short)4);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6);
        return hashtable;
    }

    public static void checkUint8(short i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i2) throws IOException {
        if (!TlsUtils.isValidUint32(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i2) throws IOException {
        if (!TlsUtils.isValidUint48(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i2) throws IOException {
        if (!TlsUtils.isValidUint64(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(int i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(long i2) {
        return (i2 & 0xFFL) == i2;
    }

    public static boolean isValidUint16(int i2) {
        return (i2 & 0xFFFF) == i2;
    }

    public static boolean isValidUint16(long i2) {
        return (i2 & 0xFFFFL) == i2;
    }

    public static boolean isValidUint24(int i2) {
        return (i2 & 0xFFFFFF) == i2;
    }

    public static boolean isValidUint24(long i2) {
        return (i2 & 0xFFFFFFL) == i2;
    }

    public static boolean isValidUint32(long i2) {
        return (i2 & 0xFFFFFFFFL) == i2;
    }

    public static boolean isValidUint48(long i2) {
        return (i2 & 0xFFFFFFFFFFFFL) == i2;
    }

    public static boolean isValidUint64(long i2) {
        return true;
    }

    public static boolean isTLSv10(ProtocolVersion version) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsContext context) {
        return TlsUtils.isTLSv10(context.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext context) {
        return TlsUtils.isTLSv11(context.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return TlsUtils.isTLSv12(context.getServerVersion());
    }

    public static void writeUint8(short i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(int i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(short i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint8(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint16(int i2, OutputStream output) throws IOException {
        output.write(i2 >>> 8);
        output.write(i2);
    }

    public static void writeUint16(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 8);
        buf[offset + 1] = (byte)i2;
    }

    public static void writeUint24(int i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint24(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 16);
        buf[offset + 1] = (byte)(i2 >>> 8);
        buf[offset + 2] = (byte)i2;
    }

    public static void writeUint32(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint32(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 24);
        buf[offset + 1] = (byte)(i2 >>> 16);
        buf[offset + 2] = (byte)(i2 >>> 8);
        buf[offset + 3] = (byte)i2;
    }

    public static void writeUint48(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint48(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 40);
        buf[offset + 1] = (byte)(i2 >>> 32);
        buf[offset + 2] = (byte)(i2 >>> 24);
        buf[offset + 3] = (byte)(i2 >>> 16);
        buf[offset + 4] = (byte)(i2 >>> 8);
        buf[offset + 5] = (byte)i2;
    }

    public static void writeUint64(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 56));
        output.write((byte)(i2 >>> 48));
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint64(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 56);
        buf[offset + 1] = (byte)(i2 >>> 48);
        buf[offset + 2] = (byte)(i2 >>> 40);
        buf[offset + 3] = (byte)(i2 >>> 32);
        buf[offset + 4] = (byte)(i2 >>> 24);
        buf[offset + 5] = (byte)(i2 >>> 16);
        buf[offset + 6] = (byte)(i2 >>> 8);
        buf[offset + 7] = (byte)i2;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], output);
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], buf, offset);
            ++offset;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], output);
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], buf, offset);
            offset += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static short decodeUint8(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(buf, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        int n2 = TlsUtils.readUint8(buf, 0);
        if (buf.length != n2 + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(buf, i2 + 1);
        }
        return sArray;
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeUint8(short uint) throws IOException {
        TlsUtils.checkUint8(uint);
        byte[] byArray = new byte[1];
        TlsUtils.writeUint8(uint, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] byArray = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int n2 = 2 * uints.length;
        byte[] byArray = new byte[2 + n2];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, byArray, 0);
        return byArray;
    }

    public static short readUint8(InputStream input) throws IOException {
        int n2 = input.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)n2;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        int n5 = input.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (long)(n2 << 24 | n3 << 16 | n4 << 8 | n5) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 24;
        n2 |= (buf[++offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return (long)(n2 |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        int n3 = TlsUtils.readUint24(input);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int n2 = TlsUtils.readUint24(buf, offset);
        int n3 = TlsUtils.readUint24(buf, offset + 3);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        int n2 = Streams.readFully(input, byArray);
        if (n2 == 0) {
            return null;
        }
        if (n2 != length) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        if (length != Streams.readFully(input, byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int n2 = buf.length;
        if (n2 > 0 && n2 != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        return TlsUtils.readFully(s2, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        return TlsUtils.readFully(n2, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        return TlsUtils.readFully(n2, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] sArray = new short[count];
        for (int i2 = 0; i2 < count; ++i2) {
            sArray[i2] = TlsUtils.readUint8(input);
        }
        return sArray;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] nArray = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            nArray[i2] = TlsUtils.readUint16(input);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(n2, n3);
    }

    public static int readVersionRaw(byte[] buf, int offset) throws IOException {
        return buf[offset] << 8 | buf[offset + 1];
    }

    public static int readVersionRaw(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(encoding);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (null == aSN1Primitive) {
            throw new TlsFatalAlert(50);
        }
        if (null != aSN1InputStream.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(encoding);
        byte[] byArray = aSN1Primitive.getEncoded("DER");
        if (!Arrays.areEqual(byArray, encoding)) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(n2 >>> 24);
        buf[offset + 1] = (byte)(n2 >>> 16);
        buf[offset + 2] = (byte)(n2 >>> 8);
        buf[offset + 3] = (byte)n2;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static Vector getAllSignatureAlgorithms() {
        Vector<Short> vector = new Vector<Short>(4);
        vector.addElement((short)0);
        vector.addElement((short)1);
        vector.addElement((short)2);
        vector.addElement((short)3);
        return vector;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.a(new SignatureAndHashAlgorithm(2, 1));
    }

    public static Vector getDefaultSignatureAlgorithms(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 2: {
                return TlsUtils.getDefaultDSSSignatureAlgorithms();
            }
            case 3: {
                return TlsUtils.getDefaultECDSASignatureAlgorithms();
            }
            case 1: {
                return TlsUtils.getDefaultRSASignatureAlgorithms();
            }
        }
        throw new IllegalArgumentException("unknown SignatureAlgorithm: " + SignatureAlgorithm.getText(signatureAlgorithm));
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext context) {
        TlsCrypto tlsCrypto = context.getCrypto();
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 2, 3};
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>();
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(sArray[i3], sArray2[i2]);
                if (!tlsCrypto.hasSignatureAndHashAlgorithm(signatureAndHashAlgorithm)) continue;
                vector.addElement(signatureAndHashAlgorithm);
            }
        }
        return vector;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsCredentialedSigner signerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(context) && (signatureAndHashAlgorithm = signerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, extensionType);
        if (byArray == null) {
            return false;
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new p(sessionID, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion clientVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(clientVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static short getSignatureAlgorithm(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 22: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static short getSignatureAlgorithmClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms);
        return byArray == null ? null : TlsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(supportedSignatureAlgorithms, false, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        Vector vector = TlsUtils.parseSupportedSignatureAlgorithms(false, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, boolean allowAnonymous, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int n2 = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
            if (!allowAnonymous && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            signatureAndHashAlgorithm.encode(output);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(boolean allowAnonymous, InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n3 = n2 / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(input);
            if (!allowAnonymous && signatureAndHashAlgorithm.getSignature() == 0) {
                throw new TlsFatalAlert(47);
            }
            vector.addElement(signatureAndHashAlgorithm);
        }
        return vector;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAlgorithm.getSignature() != 0) {
            for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
                if (signatureAndHashAlgorithm.getHash() != signatureAlgorithm.getHash() || signatureAndHashAlgorithm.getSignature() != signatureAlgorithm.getSignature()) continue;
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsSecret PRF(TlsContext context, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        int n2 = context.getSecurityParameters().getPrfAlgorithm();
        return secret.deriveUsingPRF(n2, asciiLabel, seed, length);
    }

    static byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static byte[] a(TlsContext tlsContext, String string, byte[] byArray) {
        return TlsUtils.a(tlsContext, string, byArray, 0, byArray.length);
    }

    static byte[] a(TlsContext tlsContext, String string, byte[] byArray, int n2, int n3) {
        Short s2;
        if (string != null && (s2 = (Short)c.get(string)) != null) {
            short s3 = s2;
            switch (s3) {
                case 1: 
                case 2: {
                    s3 = 4;
                }
            }
            TlsHash tlsHash = tlsContext.getCrypto().createHash(s3);
            if (tlsHash != null) {
                tlsHash.update(byArray, n2, n3);
                return tlsHash.calculateHash();
            }
        }
        return EMPTY_BYTES;
    }

    public static TlsSecret calculateMasterSecret(TlsContext context, TlsSecret preMasterSecret) {
        byte[] byArray;
        String string;
        if (context.getSecurityParameters().isExtendedMasterSecret()) {
            string = "extended master secret";
            byArray = context.getSecurityParameters().getSessionHash();
        } else {
            string = "master secret";
            byArray = TlsUtils.a(context.getSecurityParameters().getClientRandom(), context.getSecurityParameters().getServerRandom());
        }
        return TlsUtils.PRF(context, preMasterSecret, string, byArray, 48);
    }

    static byte[] a(TlsContext tlsContext, TlsHandshakeHash tlsHandshakeHash, boolean bl) {
        String string = bl ? "server finished" : "client finished";
        byte[] byArray = TlsUtils.a(tlsHandshakeHash);
        return TlsUtils.calculateTLSVerifyData(tlsContext, string, byArray);
    }

    public static byte[] calculateTLSVerifyData(TlsContext context, String asciiLabel, byte[] prfHash) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        int n2 = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(context, tlsSecret, asciiLabel, prfHash, n2).extract();
    }

    public static short getHashAlgorithmForHMACAlgorithm(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(macAlgorithm));
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    static byte[] a(TlsContext tlsContext, SignatureAndHashAlgorithm signatureAndHashAlgorithm, i i2) {
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        TlsHash tlsHash = signatureAndHashAlgorithm == null ? new CombinedHash(tlsCrypto) : tlsCrypto.createHash(signatureAndHashAlgorithm.getHash());
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        tlsHash.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        tlsHash.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        i2.a(tlsHash);
        return tlsHash.calculateHash();
    }

    static void a(TlsContext tlsContext, i i2, OutputStream outputStream) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        outputStream.write(Arrays.concatenate(securityParameters.clientRandom, securityParameters.serverRandom));
        i2.a(outputStream);
        outputStream.close();
    }

    static DigitallySigned a(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, TlsStreamSigner tlsStreamSigner, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        byte[] byArray;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(tlsContext, tlsCredentialedSigner);
        if (tlsStreamSigner != null) {
            tlsHandshakeHash.copyBufferTo(tlsStreamSigner.getOutputStream());
            byArray = tlsStreamSigner.getSignature();
        } else {
            byte[] byArray2 = signatureAndHashAlgorithm == null ? tlsContext.getSecurityParameters().getSessionHash() : tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            byArray = tlsCredentialedSigner.generateRawSignature(byArray2);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }

    static void a(TlsContext tlsContext, CertificateRequest certificateRequest, Certificate certificate, DigitallySigned digitallySigned, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        boolean bl;
        short s2 = certificate.getCertificateAt(0).getClientCertificateType();
        try {
            TlsVerifier tlsVerifier = certificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithmClient(s2));
            TlsStreamVerifier tlsStreamVerifier = tlsVerifier.getStreamVerifier(digitallySigned);
            if (tlsStreamVerifier != null) {
                tlsHandshakeHash.copyBufferTo(tlsStreamVerifier.getOutputStream());
                bl = tlsStreamVerifier.isVerified();
            } else {
                byte[] byArray;
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
                if (TlsUtils.isTLSv12(tlsContext)) {
                    TlsUtils.verifySupportedSignatureAlgorithm(certificateRequest.getSupportedSignatureAlgorithms(), signatureAndHashAlgorithm);
                    byArray = tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
                } else {
                    byArray = tlsContext.getSecurityParameters().getSessionHash();
                }
                bl = tlsVerifier.verifyRawSignature(digitallySigned, byArray);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    static DigitallySigned a(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, i i2) throws IOException {
        byte[] byArray;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(tlsContext, tlsCredentialedSigner);
        TlsStreamSigner tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
        if (tlsStreamSigner != null) {
            TlsUtils.a(tlsContext, i2, tlsStreamSigner.getOutputStream());
            byArray = tlsStreamSigner.getSignature();
        } else {
            byte[] byArray2 = TlsUtils.a(tlsContext, signatureAndHashAlgorithm, i2);
            byArray = tlsCredentialedSigner.generateRawSignature(byArray2);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }

    static void a(TlsContext tlsContext, TlsVerifier tlsVerifier, i i2, DigitallySigned digitallySigned) throws IOException {
        boolean bl;
        TlsStreamVerifier tlsStreamVerifier = tlsVerifier.getStreamVerifier(digitallySigned);
        if (tlsStreamVerifier != null) {
            TlsUtils.a(tlsContext, i2, tlsStreamVerifier.getOutputStream());
            bl = tlsStreamVerifier.isVerified();
        } else {
            byte[] byArray = TlsUtils.a(tlsContext, digitallySigned.getAlgorithm(), i2);
            bl = tlsVerifier.verifyRawSignature(digitallySigned, byArray);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    static void a(TlsHandshakeHash tlsHandshakeHash, Vector vector) {
        if (vector != null) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
                short s2 = signatureAndHashAlgorithm.getHash();
                if (HashAlgorithm.isPrivate(s2)) continue;
                tlsHandshakeHash.trackHashAlgorithm(s2);
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    private static Vector a(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return vector;
    }

    public static int getCipherType(int cipherSuite) {
        switch (TlsUtils.getEncryptionAlgorithm(cipherSuite)) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 103: 
            case 104: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: 
            case 53253: {
                return 15;
            }
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: 
            case 53251: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 53249: {
                return 10;
            }
            case 65280: 
            case 65282: 
            case 65284: 
            case 65296: 
            case 65298: 
            case 65300: {
                return 103;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 53250: {
                return 11;
            }
            case 65281: 
            case 65283: 
            case 65285: 
            case 65297: 
            case 65299: 
            case 65301: {
                return 104;
            }
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: {
                return 22;
            }
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49258: 
            case 49260: 
            case 49262: {
                return 24;
            }
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: {
                return 23;
            }
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49259: 
            case 49261: 
            case 49263: {
                return 25;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 4: 
            case 24: {
                return 2;
            }
            case 5: 
            case 138: 
            case 142: 
            case 146: 
            case 49154: 
            case 49159: 
            case 49164: 
            case 49169: 
            case 49174: 
            case 49203: {
                return 2;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 24: 
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49222: 
            case 49223: 
            case 49242: 
            case 49243: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49214: 
            case 49215: 
            case 49240: 
            case 49241: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49216: 
            case 49217: 
            case 49236: 
            case 49237: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49218: 
            case 49219: 
            case 49238: 
            case 49239: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49254: 
            case 49255: 
            case 49260: 
            case 49261: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: 
            case 65298: 
            case 65299: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49220: 
            case 49221: 
            case 49234: 
            case 49235: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: 
            case 65280: 
            case 65281: {
                return 5;
            }
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49226: 
            case 49227: 
            case 49246: 
            case 49247: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49230: 
            case 49231: 
            case 49250: 
            case 49251: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49224: 
            case 49225: 
            case 49244: 
            case 49245: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: 
            case 65284: 
            case 65285: {
                return 17;
            }
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49264: 
            case 49265: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65300: 
            case 65301: {
                return 24;
            }
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49228: 
            case 49229: 
            case 49248: 
            case 49249: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: 
            case 65282: 
            case 65283: {
                return 19;
            }
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49252: 
            case 49253: 
            case 49258: 
            case 49259: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: 
            case 65296: 
            case 65297: {
                return 13;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49212: 
            case 49213: 
            case 49232: 
            case 49233: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49256: 
            case 49257: 
            case 49262: 
            case 49263: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        return -1;
    }

    public static int getMACAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return 0;
            }
            case 1: 
            case 4: 
            case 24: {
                return 1;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int cipherSuite) {
        switch (cipherSuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49212: 
            case 49213: 
            case 49214: 
            case 49215: 
            case 49216: 
            case 49217: 
            case 49218: 
            case 49219: 
            case 49220: 
            case 49221: 
            case 49222: 
            case 49223: 
            case 49224: 
            case 49225: 
            case 49226: 
            case 49227: 
            case 49228: 
            case 49229: 
            case 49230: 
            case 49231: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49252: 
            case 49253: 
            case 49254: 
            case 49255: 
            case 49256: 
            case 49257: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49264: 
            case 49265: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static boolean isAEADCipherSuite(int cipherSuite) throws IOException {
        return 2 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isBlockCipherSuite(int cipherSuite) throws IOException {
        return 1 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isStreamCipherSuite(int cipherSuite) throws IOException {
        return 0 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (n2) {
            case 11: 
            case 12: 
            case 20: {
                return sigAlgs.contains((short)0);
            }
            case 5: 
            case 6: 
            case 19: 
            case 23: {
                return sigAlgs.contains((short)1);
            }
            case 3: 
            case 4: 
            case 22: {
                return sigAlgs.contains((short)2);
            }
            case 17: {
                return sigAlgs.contains((short)3);
            }
        }
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion serverVersion) {
        return TlsUtils.getMinimumVersion(cipherSuite).isEqualOrEarlierVersionOf(serverVersion.getEquivalentTLSVersion());
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext context, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        if (!TlsUtils.isTLSv12(context)) {
            return null;
        }
        if (sigHashAlgs == null) {
            sigHashAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        for (int i2 = 0; i2 < sigHashAlgs.size(); ++i2) {
            short s2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i2);
            if (signatureAndHashAlgorithm2.getSignature() != signatureAlgorithm || (s2 = signatureAndHashAlgorithm2.getHash()) < MINIMUM_HASH_STRICT) continue;
            if (signatureAndHashAlgorithm == null) {
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            short s3 = signatureAndHashAlgorithm.getHash();
            if (s3 < MINIMUM_HASH_PREFERRED) {
                if (s2 <= s3) continue;
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            if (s2 < MINIMUM_HASH_PREFERRED || s2 >= s3) continue;
            signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
        }
        if (signatureAndHashAlgorithm == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            return TlsUtils.getAllSignatureAlgorithms();
        }
        Vector<Short> vector = new Vector<Short>(4);
        vector.addElement((short)0);
        for (int i2 = 0; i2 < sigHashAlgs.size(); ++i2) {
            short s2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i2);
            if (signatureAndHashAlgorithm.getHash() < MINIMUM_HASH_STRICT || vector.contains(s2 = signatureAndHashAlgorithm.getSignature())) continue;
            vector.addElement(s2);
        }
        return vector;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] baseCipherSuiteList) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 != baseCipherSuiteList.length; ++i2) {
            if (!TlsUtils.isSupportedCipherSuite(crypto, baseCipherSuiteList[i2])) continue;
            arrayList.add(baseCipherSuiteList[i2]);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 != nArray.length; ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto crypto, int cipherSuite) {
        return TlsUtils.isSupportedKeyExchange(crypto, TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) && crypto.hasEncryptionAlgorithm(TlsUtils.getEncryptionAlgorithm(cipherSuite)) && crypto.hasMacAlgorithm(TlsUtils.getMACAlgorithm(cipherSuite));
    }

    public static boolean isStaticKeyAgreement(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedKeyExchange(TlsCrypto crypto, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                return crypto.hasDHAgreement();
            }
            case 3: 
            case 4: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm(2);
            }
            case 5: 
            case 6: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm(1);
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                return crypto.hasECDHAgreement();
            }
            case 17: {
                return crypto.hasECDHAgreement() && crypto.hasSignatureAlgorithm(3);
            }
            case 19: {
                return crypto.hasECDHAgreement() && crypto.hasSignatureAlgorithm(1);
            }
            case 0: 
            case 13: {
                return true;
            }
            case 1: 
            case 2: 
            case 15: {
                return crypto.hasRSAEncryption();
            }
            case 21: {
                return crypto.hasSRPAuthentication();
            }
            case 22: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm(2);
            }
            case 23: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm(1);
            }
        }
        return false;
    }

    static byte[] a(TlsHandshakeHash tlsHandshakeHash) {
        return tlsHandshakeHash.forkPRFHash().calculateHash();
    }

    static void b(TlsContext tlsContext, TlsHandshakeHash tlsHandshakeHash, boolean bl) {
        if (bl || !tlsContext.getCrypto().hasAllRawSignatureAlgorithms()) {
            tlsHandshakeHash.forceBuffering();
        }
        tlsHandshakeHash.sealHashAlgorithms();
    }

    static void a(Certificate certificate, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        byte[] byArray = certificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (byArray != null) {
            Enumeration enumeration = ((ASN1Sequence)TlsUtils.readDERObject(byArray)).getObjects();
            while (enumeration.hasMoreElements()) {
                Integer n2;
                BigInteger bigInteger = ((ASN1Integer)enumeration.nextElement()).getPositiveValue();
                if (bigInteger.bitLength() > 16 || !hashtable.containsKey(n2 = Integers.valueOf(bigInteger.intValue())) || hashtable2.containsKey(n2)) continue;
                throw new TlsFatalAlert(46);
            }
        }
    }

    static void a(Certificate certificate, CertificateStatus certificateStatus, TlsKeyExchange tlsKeyExchange, TlsAuthentication tlsAuthentication, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        TlsUtils.a(certificate, hashtable, hashtable2);
        tlsKeyExchange.processServerCertificate(certificate);
        tlsAuthentication.notifyServerCertificate(new n(certificate, certificateStatus));
    }

    static CertificateRequest a(CertificateRequest certificateRequest, TlsKeyExchange tlsKeyExchange) throws IOException {
        short[] sArray = tlsKeyExchange.getClientCertificateTypes();
        if (sArray == null || sArray.length < 1) {
            throw new TlsFatalAlert(10);
        }
        if ((certificateRequest = TlsUtils.a(certificateRequest, sArray)) == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest a(CertificateRequest certificateRequest, short[] sArray) {
        if (TlsUtils.a(sArray, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] sArray2 = TlsUtils.b(certificateRequest.getCertificateTypes(), sArray);
        if (sArray2.length < 1) {
            return null;
        }
        return new CertificateRequest(sArray2, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean a(short[] sArray, short[] sArray2) {
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            if (Arrays.contains(sArray, sArray2[i2])) continue;
            return false;
        }
        return true;
    }

    static short[] b(short[] sArray, short[] sArray2) {
        short[] sArray3 = new short[Math.min(sArray.length, sArray2.length)];
        int n2 = 0;
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            if (!Arrays.contains(sArray, sArray2[i2])) continue;
            sArray3[n2++] = sArray2[i2];
        }
        return TlsUtils.a(sArray3, n2);
    }

    static short[] a(short[] sArray, int n2) {
        if (n2 < sArray.length) {
            return sArray;
        }
        short[] sArray2 = new short[n2];
        System.arraycopy(sArray, 0, sArray2, 0, n2);
        return sArray2;
    }
}

