/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.tls.IdentifierType;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TrustedAuthority {
    protected short identifierType;
    protected Object identifier;

    public TrustedAuthority(short identifierType, Object identifier) {
        if (!TrustedAuthority.isCorrectType(identifierType, identifier)) {
            throw new IllegalArgumentException("'identifier' is not an instance of the correct type");
        }
        this.identifierType = identifierType;
        this.identifier = identifier;
    }

    public short getIdentifierType() {
        return this.identifierType;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public byte[] getCertSHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public byte[] getKeySHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public X500Name getX509Name() {
        this.checkCorrectType((short)2);
        return (X500Name)this.identifier;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.identifierType, output);
        switch (this.identifierType) {
            case 1: 
            case 3: {
                byte[] byArray = (byte[])this.identifier;
                output.write(byArray);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                X500Name x500Name = (X500Name)this.identifier;
                byte[] byArray = x500Name.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static TrustedAuthority parse(InputStream input) throws IOException {
        byte[] byArray;
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 1: 
            case 3: {
                byArray = TlsUtils.readFully(20, input);
                break;
            }
            case 0: {
                byArray = null;
                break;
            }
            case 2: {
                byte[] byArray2 = TlsUtils.readOpaque16(input);
                ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray2);
                X500Name x500Name = X500Name.getInstance(aSN1Primitive);
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new TrustedAuthority(s2, byArray);
    }

    protected void checkCorrectType(short expectedIdentifierType) {
        if (this.identifierType != expectedIdentifierType || !TrustedAuthority.isCorrectType(expectedIdentifierType, this.identifier)) {
            throw new IllegalStateException("TrustedAuthority is not of type " + IdentifierType.getName(expectedIdentifierType));
        }
    }

    protected static boolean isCorrectType(short identifierType, Object identifier) {
        switch (identifierType) {
            case 1: 
            case 3: {
                return TrustedAuthority.isSHA1Hash(identifier);
            }
            case 0: {
                return identifier == null;
            }
            case 2: {
                return identifier instanceof X500Name;
            }
        }
        throw new IllegalArgumentException("'identifierType' is an unsupported IdentifierType");
    }

    protected static boolean isSHA1Hash(Object identifier) {
        return identifier instanceof byte[] && ((byte[])identifier).length == 20;
    }
}

