/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import com.enterprisedt.bouncycastle.util.Times;

abstract class a
implements TlsContext {
    private static long a = Times.nanoTime();
    private TlsCrypto b;
    private TlsNonceGenerator c;
    private SecurityParameters d;
    private ProtocolVersion e = null;
    private ProtocolVersion f = null;
    private TlsSession g = null;
    private Object h = null;

    private static synchronized long a() {
        return ++a;
    }

    private static TlsNonceGenerator a(TlsCrypto tlsCrypto, SecurityParameters securityParameters) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(com.enterprisedt.bouncycastle.tls.a.a(), byArray, 0);
        Pack.longToBigEndian(Times.nanoTime(), byArray, 8);
        byArray[0] = (byte)securityParameters.a;
        return tlsCrypto.createNonceGenerator(byArray);
    }

    a(TlsCrypto tlsCrypto, SecurityParameters securityParameters) {
        this.b = tlsCrypto;
        this.c = com.enterprisedt.bouncycastle.tls.a.a(tlsCrypto, securityParameters);
        this.d = securityParameters;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.b;
    }

    @Override
    public TlsNonceGenerator getNonceGenerator() {
        return this.c;
    }

    @Override
    public SecurityParameters getSecurityParameters() {
        return this.d;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.e;
    }

    public void setClientVersion(ProtocolVersion clientVersion) {
        this.e = clientVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.f;
    }

    public void setServerVersion(ProtocolVersion serverVersion) {
        this.f = serverVersion;
    }

    @Override
    public TlsSession getResumableSession() {
        TlsSession tlsSession = this.getSession();
        if (tlsSession == null || !tlsSession.isResumable()) {
            return null;
        }
        return tlsSession;
    }

    @Override
    public TlsSession getSession() {
        return this.g;
    }

    void a(TlsSession tlsSession) {
        this.g = tlsSession;
    }

    @Override
    public Object getUserObject() {
        return this.h;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.h = userObject;
    }

    @Override
    public byte[] exportChannelBinding(int channelBinding) {
        switch (channelBinding) {
            case 0: {
                byte[] byArray = this.getSecurityParameters().getTLSServerEndPoint();
                if (byArray == null) {
                    throw new IllegalStateException("'tls-server-end-point' channel binding unavailable before handshake completion");
                }
                if (byArray.length < 1) {
                    return null;
                }
                return Arrays.clone(byArray);
            }
            case 1: {
                byte[] byArray = this.getSecurityParameters().getTLSUnique();
                if (byArray == null) {
                    throw new IllegalStateException("'tls-unique' channel binding unavailable before handshake completion");
                }
                return Arrays.clone(byArray);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray = securityParameters.getClientRandom();
        byte[] byArray2 = securityParameters.getServerRandom();
        int n2 = byArray.length + byArray2.length;
        if (context_value != null) {
            n2 += 2 + context_value.length;
        }
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray, 0, byArray3, n3, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n3 += byArray.length, byArray2.length);
        n3 += byArray2.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, byArray3, n3);
            System.arraycopy(context_value, 0, byArray3, n3 += 2, context_value.length);
            n3 += context_value.length;
        }
        if (n3 != n2) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, securityParameters.getMasterSecret(), asciiLabel, byArray3, length).extract();
    }
}

