/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Client;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Server;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public interface TlsCrypto {
    public boolean hasAllRawSignatureAlgorithms();

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasHashAlgorithm(short var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedGroup(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(int var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(short var1);

    public TlsHMAC createHMAC(int var1);

    public TlsNonceGenerator createNonceGenerator(byte[] var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);
}

