/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    public static final int NONCE_RFC7905 = 2;
    protected final TlsCryptoParameters cryptoParams;
    protected final int macSize;
    protected final int record_iv_length;
    protected final TlsAEADCipherImpl decryptCipher;
    protected final TlsAEADCipherImpl encryptCipher;
    protected final byte[] encryptImplicitNonce;
    protected final byte[] decryptImplicitNonce;
    protected final int nonceMode;

    public TlsAEADCipher(TlsCryptoParameters cryptoParams, TlsAEADCipherImpl encryptCipher, TlsAEADCipherImpl decryptCipher, int cipherKeySize, int macSize) throws IOException {
        this(cryptoParams, encryptCipher, decryptCipher, cipherKeySize, macSize, 1);
    }

    public TlsAEADCipher(TlsCryptoParameters cryptoParams, TlsAEADCipherImpl encryptCipher, TlsAEADCipherImpl decryptCipher, int cipherKeySize, int macSize, int nonceMode) throws IOException {
        TlsAEADCipherImpl tlsAEADCipherImpl;
        TlsAEADCipherImpl tlsAEADCipherImpl2;
        int n2;
        if (!TlsImplUtils.isTLSv12(cryptoParams)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = nonceMode;
        switch (nonceMode) {
            case 1: {
                n2 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n2 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.cryptoParams = cryptoParams;
        this.macSize = macSize;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            tlsAEADCipherImpl2 = decryptCipher;
            tlsAEADCipherImpl = encryptCipher;
        } else {
            tlsAEADCipherImpl2 = encryptCipher;
            tlsAEADCipherImpl = decryptCipher;
        }
        int n3 = 2 * cipherKeySize + 2 * n2;
        byte[] byArray = TlsImplUtils.calculateKeyBlock(cryptoParams, n3);
        int n4 = 0;
        tlsAEADCipherImpl2.setKey(byArray, n4, cipherKeySize);
        tlsAEADCipherImpl.setKey(byArray, n4 += cipherKeySize, cipherKeySize);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n4 += cipherKeySize, n4 + n2);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n4 += n2, n4 + n2);
        if ((n4 += n2) != n3) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
        } else {
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
        }
        byte[] byArray4 = new byte[n2 + this.record_iv_length];
        this.encryptCipher.init(byArray4, macSize, null);
        this.decryptCipher.init(byArray4, macSize, null);
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        return plaintextLimit + this.macSize + this.record_iv_length;
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.macSize - this.record_iv_length;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        int n2;
        byte[] byArray = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(seqNo, byArray, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, byArray, byArray.length - 8);
                for (n2 = 0; n2 < this.encryptImplicitNonce.length; ++n2) {
                    int n3 = n2;
                    byArray[n3] = (byte)(byArray[n3] ^ this.encryptImplicitNonce[n2]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n2 = offset;
        int n4 = len;
        int n5 = this.encryptCipher.getOutputSize(n4);
        byte[] byArray2 = new byte[this.record_iv_length + n5];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray, byArray.length - this.record_iv_length, byArray2, 0, this.record_iv_length);
        }
        int n6 = this.record_iv_length;
        byte[] byArray3 = this.getAdditionalData(seqNo, type, n4);
        try {
            this.encryptCipher.init(byArray, this.macSize, byArray3);
            n6 += this.encryptCipher.doFinal(plaintext, n2, n4, byArray2, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n6 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray, 0, this.decryptImplicitNonce.length);
                System.arraycopy(ciphertext, offset, byArray, byArray.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, byArray, byArray.length - 8);
                for (n2 = 0; n2 < this.decryptImplicitNonce.length; ++n2) {
                    int n3 = n2;
                    byArray[n3] = (byte)(byArray[n3] ^ this.decryptImplicitNonce[n2]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n2 = offset + this.record_iv_length;
        int n4 = len - this.record_iv_length;
        int n5 = this.decryptCipher.getOutputSize(n4);
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        byte[] byArray3 = this.getAdditionalData(seqNo, type, n5);
        try {
            this.decryptCipher.init(byArray, this.macSize, byArray3);
            n6 += this.decryptCipher.doFinal(ciphertext, n2, n4, byArray2, n6);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n6 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray2;
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(seqNo, byArray, 0);
        TlsUtils.writeUint8(type, byArray, 8);
        TlsUtils.writeVersion(this.cryptoParams.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(len, byArray, 11);
        return byArray;
    }
}

