/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import com.enterprisedt.bouncycastle.tls.crypto.impl.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.SecureRandom;

public class TlsBlockCipher
implements TlsCipher {
    protected final TlsCrypto crypto;
    protected final TlsCryptoParameters cryptoParams;
    protected final byte[] randomData;
    protected final boolean encryptThenMAC;
    protected final boolean useExplicitIV;
    protected final boolean useExtraPadding;
    protected final TlsBlockCipherImpl decryptCipher;
    protected final TlsBlockCipherImpl encryptCipher;
    protected final TlsSuiteMac readMac;
    protected final TlsSuiteMac writeMac;

    public TlsBlockCipher(TlsCrypto crypto, TlsCryptoParameters cryptoParams, TlsBlockCipherImpl encryptCipher, TlsBlockCipherImpl decryptCipher, TlsHMAC clientMac, TlsHMAC serverMac, int cipherKeySize) throws IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl;
        TlsBlockCipherImpl tlsBlockCipherImpl2;
        this.cryptoParams = cryptoParams;
        this.crypto = crypto;
        this.randomData = cryptoParams.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = cryptoParams.getSecurityParameters().isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(cryptoParams);
        SecurityParameters securityParameters = cryptoParams.getSecurityParameters();
        this.useExtraPadding = securityParameters.isExtendedPadding() && !cryptoParams.getServerVersion().isDTLS() && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            tlsBlockCipherImpl2 = decryptCipher;
            tlsBlockCipherImpl = encryptCipher;
        } else {
            tlsBlockCipherImpl2 = encryptCipher;
            tlsBlockCipherImpl = decryptCipher;
        }
        int n2 = 2 * cipherKeySize + clientMac.getMacLength() + serverMac.getMacLength();
        if (!this.useExplicitIV) {
            n2 += tlsBlockCipherImpl2.getBlockSize() + tlsBlockCipherImpl.getBlockSize();
        }
        byte[] byArray = TlsImplUtils.calculateKeyBlock(cryptoParams, n2);
        int n3 = 0;
        clientMac.setKey(byArray, n3, clientMac.getMacLength());
        serverMac.setKey(byArray, n3 += clientMac.getMacLength(), serverMac.getMacLength());
        tlsBlockCipherImpl2.setKey(byArray, n3 += serverMac.getMacLength(), cipherKeySize);
        tlsBlockCipherImpl.setKey(byArray, n3 += cipherKeySize, cipherKeySize);
        n3 += cipherKeySize;
        if (!this.useExplicitIV) {
            tlsBlockCipherImpl2.init(byArray, n3, tlsBlockCipherImpl2.getBlockSize());
            tlsBlockCipherImpl.init(byArray, n3 += tlsBlockCipherImpl2.getBlockSize(), tlsBlockCipherImpl.getBlockSize());
            n3 += tlsBlockCipherImpl.getBlockSize();
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new a(cryptoParams, serverMac);
            this.readMac = new a(cryptoParams, clientMac);
        } else {
            this.writeMac = new a(cryptoParams, clientMac);
            this.readMac = new a(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        int n2;
        int n3 = this.encryptCipher.getBlockSize();
        int n4 = this.writeMac.getSize();
        int n5 = plaintextLimit;
        if (this.useExplicitIV) {
            n5 += n3;
        }
        int n6 = n2 = this.useExtraPadding ? 255 : n3;
        if (this.encryptThenMAC) {
            n5 += n2;
            n5 -= n5 % n3;
            n5 += n4;
        } else {
            n5 += n4;
            n5 += n2;
            n5 -= n5 % n3;
        }
        return n5;
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = ciphertextLimit;
        if (this.useExplicitIV) {
            n4 -= n2;
        }
        if (this.encryptThenMAC) {
            n4 -= n3;
            n4 -= n4 % n2;
        } else {
            n4 -= n4 % n2;
            n4 -= n3;
        }
        return --n4;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        int n2;
        int n3 = this.encryptCipher.getBlockSize();
        int n4 = this.writeMac.getSize();
        int n5 = len;
        if (!this.encryptThenMAC) {
            n5 += n4;
        }
        int n6 = n3 - 1 - n5 % n3;
        if (this.useExtraPadding) {
            n2 = (255 - n6) / n3;
            int n7 = this.chooseExtraPadBlocks(this.crypto.getSecureRandom(), n2);
            n6 += n7 * n3;
        }
        n2 = len + n4 + n6 + 1;
        if (this.useExplicitIV) {
            n2 += n3;
        }
        byte[] byArray = new byte[n2];
        int n8 = 0;
        if (this.useExplicitIV) {
            byte[] byArray2 = this.cryptoParams.getNonceGenerator().generateNonce(n3);
            this.encryptCipher.init(byArray2, 0, n3);
            System.arraycopy(byArray2, 0, byArray, n8, n3);
            n8 += n3;
        }
        int n9 = n8;
        System.arraycopy(plaintext, offset, byArray, n8, len);
        n8 += len;
        if (!this.encryptThenMAC) {
            byte[] byArray3 = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
            System.arraycopy(byArray3, 0, byArray, n8, byArray3.length);
            n8 += byArray3.length;
        }
        for (int i2 = 0; i2 <= n6; ++i2) {
            byArray[n8++] = (byte)n6;
        }
        this.encryptCipher.doFinal(byArray, n9, n8 - n9, byArray, n9);
        if (this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(seqNo, type, byArray, 0, n8);
            System.arraycopy(byArray4, 0, byArray, n8, byArray4.length);
            n8 += byArray4.length;
        }
        return byArray;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        int n3;
        int n4 = this.decryptCipher.getBlockSize();
        int n5 = this.readMac.getSize();
        int n6 = n4;
        n6 = this.encryptThenMAC ? (n6 += n5) : Math.max(n6, n5 + 1);
        if (this.useExplicitIV) {
            n6 += n4;
        }
        if (len < n6) {
            throw new TlsFatalAlert(50);
        }
        int n7 = len;
        if (this.encryptThenMAC) {
            n7 -= n5;
        }
        if (n7 % n4 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            n3 = offset + len;
            byte[] byArray = Arrays.copyOfRange(ciphertext, n3 - n5, n3);
            byte[] byArray2 = this.readMac.calculateMac(seqNo, type, ciphertext, offset, len - n5);
            int n8 = n2 = !Arrays.constantTimeAreEqual(byArray2, byArray) ? 1 : 0;
            if (n2 != 0) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(ciphertext, offset, n4);
            offset += n4;
            n7 -= n4;
        }
        this.decryptCipher.doFinal(ciphertext, offset, n7, ciphertext, offset);
        n3 = this.checkPaddingConstantTime(ciphertext, offset, n7, n4, this.encryptThenMAC ? 0 : n5);
        boolean bl = n3 == 0;
        int n9 = n7 - n3;
        if (!this.encryptThenMAC) {
            n2 = n9 -= n5;
            int n10 = offset + n2;
            byte[] byArray = Arrays.copyOfRange(ciphertext, n10, n10 + n5);
            byte[] byArray3 = this.readMac.calculateMacConstantTime(seqNo, type, ciphertext, offset, n2, n7 - n5, this.randomData);
            bl |= !Arrays.constantTimeAreEqual(byArray3, byArray);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + n9);
    }

    protected int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int n2 = off + len;
        byte by = buf[n2 - 1];
        int n3 = by & 0xFF;
        int n4 = n3 + 1;
        int n5 = 0;
        int n6 = 0;
        if (macSize + n4 > len) {
            n4 = 0;
        } else {
            int n7 = n2 - n4;
            do {
                n6 = (byte)(n6 | buf[n7++] ^ by);
            } while (n7 < n2);
            n5 = n4;
            if (n6 != 0) {
                n4 = 0;
            }
        }
        byte[] byArray = this.randomData;
        while (n5 < 256) {
            n6 = (byte)(n6 | byArray[n5++] ^ by);
        }
        byArray[0] = (byte)(byArray[0] ^ n6);
        return n4;
    }

    protected int chooseExtraPadBlocks(SecureRandom r2, int max) {
        int n2 = r2.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, max);
    }

    protected int lowestBitSet(int x2) {
        if (x2 == 0) {
            return 32;
        }
        int n2 = 0;
        while ((x2 & 1) == 0) {
            ++n2;
            x2 >>= 1;
        }
        return n2;
    }
}

