/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.DefaultTlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner a(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter) {
        BcTlsSigner bcTlsSigner;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            bcTlsSigner = new BcTlsRSASigner(bcTlsCrypto, (RSAKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            bcTlsSigner = new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            bcTlsSigner = new BcTlsECDSASigner(bcTlsCrypto, (ECPrivateKeyParameters)asymmetricKeyParameter);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        return bcTlsSigner;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.a(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

