/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.KeyUsage;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoException;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            return Certificate.getInstance(encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TlsCryptoException("unable to decode certificate: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificate.parseCertificate(encoding));
    }

    public BcTlsCertificate(BcTlsCrypto crypto, Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        if (asymmetricKeyParameter.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(43, (Throwable)exception);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(46, (Throwable)runtimeException);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        DSAPublicKeyParameters dSAPublicKeyParameters;
        try {
            dSAPublicKeyParameters = (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyDSS(dSAPublicKeyParameters);
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        ECPublicKeyParameters eCPublicKeyParameters;
        try {
            eCPublicKeyParameters = (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyEC(eCPublicKeyParameters);
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        RSAKeyParameters rSAKeyParameters;
        try {
            rSAKeyParameters = (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyRSA(rSAKeyParameters);
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions(extensions)) != null && ((n2 = keyUsage.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DSAPublicKeyParameters validatePubKeyDSS(DSAPublicKeyParameters pubKeyDSS) throws IOException {
        return pubKeyDSS;
    }

    protected ECPublicKeyParameters validatePubKeyEC(ECPublicKeyParameters pubKeyEC) throws IOException {
        return pubKeyEC;
    }

    protected RSAKeyParameters validatePubKeyRSA(RSAKeyParameters pubKeyRSA) throws IOException {
        return pubKeyRSA;
    }
}

