/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String address) {
        return IPAddress.isValidIPv4(address) || IPAddress.isValidIPv6(address);
    }

    public static boolean isValidWithNetMask(String address) {
        return IPAddress.isValidIPv4WithNetmask(address) || IPAddress.isValidIPv6WithNetmask(address);
    }

    public static boolean isValidIPv4(String address) {
        int n2;
        if (address.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string = address + ".";
        int n4 = 0;
        while (n4 < string.length() && (n2 = string.indexOf(46, n4)) > n4) {
            int n5;
            if (n3 == 4) {
                return false;
            }
            try {
                n5 = Integer.parseInt(string.substring(n4, n2));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n5 < 0 || n5 > 255) {
                return false;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 4;
    }

    public static boolean isValidIPv4WithNetmask(String address) {
        int n2 = address.indexOf("/");
        String string = address.substring(n2 + 1);
        return n2 > 0 && IPAddress.isValidIPv4(address.substring(0, n2)) && (IPAddress.isValidIPv4(string) || IPAddress.a(string, 32));
    }

    public static boolean isValidIPv6WithNetmask(String address) {
        int n2 = address.indexOf("/");
        String string = address.substring(n2 + 1);
        return n2 > 0 && IPAddress.isValidIPv6(address.substring(0, n2)) && (IPAddress.isValidIPv6(string) || IPAddress.a(string, 128));
    }

    private static boolean a(String string, int n2) {
        try {
            int n3 = Integer.parseInt(string);
            return n3 >= 0 && n3 <= n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidIPv6(String address) {
        int n2;
        if (address.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string = address + ":";
        boolean bl = false;
        int n4 = 0;
        while (n4 < string.length() && (n2 = string.indexOf(58, n4)) >= n4) {
            if (n3 == 8) {
                return false;
            }
            if (n4 != n2) {
                String string2 = string.substring(n4, n2);
                if (n2 == string.length() - 1 && string2.indexOf(46) > 0) {
                    if (!IPAddress.isValidIPv4(string2)) {
                        return false;
                    }
                    ++n3;
                } else {
                    int n5;
                    try {
                        n5 = Integer.parseInt(string.substring(n4, n2), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    if (n5 < 0 || n5 > 65535) {
                        return false;
                    }
                }
            } else {
                if (n2 != 1 && n2 != string.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 8 || bl;
    }
}

