/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import com.enterprisedt.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Properties {
    private static final ThreadLocal a = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String propertyName) {
        try {
            String string = Properties.a(propertyName);
            if (string != null) {
                return "true".equals(Strings.toLowerCase(string));
            }
            return false;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean setThreadOverride(String propertyName, boolean enable) {
        boolean bl = Properties.isOverrideSet(propertyName);
        HashMap<String, String> hashMap = (HashMap<String, String>)a.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        hashMap.put(propertyName, enable ? "true" : "false");
        a.set(hashMap);
        return bl;
    }

    public static boolean removeThreadOverride(String propertyName) {
        boolean bl = Properties.isOverrideSet(propertyName);
        Map map = (Map)a.get();
        if (map == null) {
            return false;
        }
        map.remove(propertyName);
        if (map.isEmpty()) {
            a.remove();
        } else {
            a.set(map);
        }
        return bl;
    }

    public static BigInteger asBigInteger(String propertyName) {
        String string = Properties.a(propertyName);
        if (string != null) {
            return new BigInteger(string);
        }
        return null;
    }

    public static Set<String> asKeySet(String propertyName) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = Properties.a(propertyName);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static String a(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map map = (Map)a.get();
                if (map != null) {
                    return map.get(string);
                }
                return System.getProperty(string);
            }
        });
    }
}

