/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Base64Encoder;
import com.enterprisedt.bouncycastle.util.encoders.DecoderException;
import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import com.enterprisedt.bouncycastle.util.encoders.EncoderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64 {
    private static final Encoder a = new Base64Encoder();

    public static String toBase64String(byte[] data) {
        return Base64.toBase64String(data, 0, data.length);
    }

    public static String toBase64String(byte[] data, int off, int length) {
        byte[] byArray = Base64.encode(data, off, length);
        return Strings.fromByteArray(byArray);
    }

    public static byte[] encode(byte[] data) {
        return Base64.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        int n2 = (length + 2) / 3 * 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            a.encode(data, off, length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new EncoderException("exception encoding base64 string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return a.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return a.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        int n2 = data.length / 4 * 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            a.decode(data, 0, data.length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("unable to decode base64 data: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(String data) {
        int n2 = data.length() / 4 * 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            a.decode(data, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("unable to decode base64 string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return a.decode(data, out);
    }

    public static int decode(byte[] base64Data, int start, int length, OutputStream out) {
        try {
            return a.decode(base64Data, start, length, out);
        }
        catch (Exception exception) {
            throw new DecoderException("unable to decode base64 data: " + exception.getMessage(), exception);
        }
    }
}

