/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Translator;

public class BufferedDecoder {
    protected byte[] buf;
    protected int bufOff;
    protected Translator translator;

    public BufferedDecoder(Translator translator, int bufSize) {
        this.translator = translator;
        if (bufSize % translator.getEncodedBlockSize() != 0) {
            throw new IllegalArgumentException("buffer size not multiple of input block size");
        }
        this.buf = new byte[bufSize];
        this.bufOff = 0;
    }

    public int processByte(byte in, byte[] out, int outOff) {
        int n2 = 0;
        this.buf[this.bufOff++] = in;
        if (this.bufOff == this.buf.length) {
            n2 = this.translator.decode(this.buf, 0, this.buf.length, out, outOff);
            this.bufOff = 0;
        }
        return n2;
    }

    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = 0;
        int n3 = this.buf.length - this.bufOff;
        if (len > n3) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, n3);
            n2 += this.translator.decode(this.buf, 0, this.buf.length, out, outOff);
            this.bufOff = 0;
            outOff += n2;
            int n4 = (len -= n3) - len % this.buf.length;
            n2 += this.translator.decode(in, inOff += n3, n4, out, outOff);
            len -= n4;
            inOff += n4;
        }
        if (len != 0) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, len);
            this.bufOff += len;
        }
        return n2;
    }
}

